/*
 * Decompiled with CFR 0.152.
 */
package com.verdegraphics.vgenexcelerator;

import com.verdegraphics.vgenexcelerator.ProgressListenable;
import com.verdegraphics.vgenexcelerator.ProgressListener;
import com.verdegraphics.vgenexcelerator.ProgressUpdateEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.concurrent.Callable;

public class VGENProcessor
implements ProgressListenable,
Callable<ArrayList<Object[]>> {
    private static final String NO_DATA = "NO DATA TO REPORT";
    private static final String DELIMITER = "^";
    private final File inputFile;
    private final String delimiter;
    private final int delimPerLine;
    private final ArrayList<Object[]> data;
    private final long totalAmountToDo;
    private long amountDone;
    private int progress;
    private String operationName;
    private final ArrayList<ProgressListener> progressListeners;

    private VGENProcessor() {
        this.inputFile = null;
        this.delimiter = null;
        this.delimPerLine = 0;
        this.data = null;
        this.totalAmountToDo = 0L;
        this.progressListeners = null;
    }

    public VGENProcessor(File inputFile, String delimiter, int delimPerLine) throws IOException, IllegalArgumentException {
        this.inputFile = inputFile;
        this.delimiter = delimiter;
        this.delimPerLine = delimPerLine;
        this.data = new ArrayList();
        this.totalAmountToDo = inputFile.length();
        this.progressListeners = new ArrayList();
    }

    public VGENProcessor(File inputFile, int delimPerLine) throws IOException {
        this.inputFile = inputFile;
        this.delimiter = DELIMITER;
        this.delimPerLine = delimPerLine;
        this.data = new ArrayList();
        this.totalAmountToDo = inputFile.length();
        this.progressListeners = new ArrayList();
    }

    public VGENProcessor(File inputFile) throws IOException {
        this.inputFile = inputFile;
        this.delimiter = DELIMITER;
        this.delimPerLine = this.delimPerLine(inputFile);
        this.data = new ArrayList();
        this.totalAmountToDo = inputFile.length();
        this.progressListeners = new ArrayList();
    }

    public static ArrayList<Object[]> processReport(File inputFile, String delimiter, int delimPerLine) throws IOException, InterruptedException {
        return new VGENProcessor(inputFile, delimiter, delimPerLine).processReport();
    }

    public static ArrayList<Object[]> processReport(File inputFile) throws IOException, InterruptedException {
        return new VGENProcessor(inputFile).processReport();
    }

    public ArrayList<Object[]> processReport() throws IOException, InterruptedException {
        String inputLine;
        if (!this.data.isEmpty()) {
            return this.data;
        }
        this.setCurrentOperation("Processing VGEN data...");
        StringBuilder outputLine = new StringBuilder();
        int delimCount = 0;
        boolean endOfRow = false;
        boolean firstRow = true;
        boolean inReportHeaders = false;
        BufferedReader reader = new BufferedReader(new FileReader(this.inputFile));
        while ((inputLine = reader.readLine()) != null) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            this.updateAmountDone(inputLine.length());
            if (inputLine.toUpperCase().contains(DELIMITER)) {
                inReportHeaders = true;
            }
            if (!inReportHeaders) continue;
            if (inputLine.isEmpty() && (inputLine = reader.readLine()).isEmpty()) break;
            if (endOfRow && (delimCount += inputLine.length() - inputLine.replace(this.delimiter, "").length()) == 0) {
                outputLine = outputLine.append(inputLine);
                this.data.add(VGENProcessor.processRow(outputLine.toString()));
                outputLine = new StringBuilder();
                endOfRow = false;
            } else {
                if (endOfRow && !firstRow) {
                    this.data.add(VGENProcessor.processRow(outputLine.toString()));
                    outputLine = new StringBuilder();
                }
                if (delimCount < this.delimPerLine) {
                    inputLine = inputLine.replaceAll(String.format("%n", new Object[0]), "");
                    outputLine = outputLine.append(inputLine);
                    endOfRow = false;
                } else {
                    outputLine = outputLine.append(inputLine);
                    delimCount = 0;
                    endOfRow = true;
                }
            }
            firstRow = false;
        }
        if (!outputLine.toString().isEmpty()) {
            this.data.add(VGENProcessor.processRow(outputLine.toString()));
        }
        reader.close();
        this.inputFile.delete();
        for (int i = 0; i < this.data.get(0).length; ++i) {
            int noDataIndex = this.data.get(0)[i].toString().toUpperCase().indexOf(NO_DATA);
            if (noDataIndex <= -1) continue;
            this.data.get((int)0)[i] = this.data.get(0)[i].toString().substring(0, noDataIndex);
        }
        this.setProgress(100);
        return this.data;
    }

    private int delimPerLine(File inputFile) throws IOException {
        String inputLine;
        BufferedReader reader = new BufferedReader(new FileReader(inputFile));
        StringBuilder outputLine = new StringBuilder();
        int delimCount = 0;
        boolean inReportHeaders = false;
        boolean endOfHeaders = false;
        while ((inputLine = reader.readLine()) != null && !endOfHeaders) {
            if (inputLine.toUpperCase().contains(this.delimiter)) {
                inReportHeaders = true;
            }
            if (!inReportHeaders) continue;
            if (inputLine.isEmpty() || Character.isDigit(inputLine.charAt(0))) {
                endOfHeaders = true;
                continue;
            }
            delimCount += inputLine.length() - inputLine.replace(this.delimiter, "").length();
        }
        return delimCount;
    }

    private static Object[] processRow(String row) {
        String[] lineComponents = row.split("\\^");
        Object[] rowData = new Object[lineComponents.length];
        for (int i = 0; i < lineComponents.length; ++i) {
            lineComponents[i] = lineComponents[i].trim();
            try {
                int value = Integer.parseInt(lineComponents[i]);
                rowData[i] = value;
                continue;
            }
            catch (NumberFormatException value) {
                try {
                    double value2 = Double.parseDouble(lineComponents[i]);
                    rowData[i] = value2;
                    continue;
                }
                catch (NumberFormatException value2) {
                    try {
                        LocalDate value3 = LocalDate.parse(lineComponents[i], DateTimeFormatter.ofPattern("MM/dd/yyyy"));
                        rowData[i] = value3;
                        continue;
                    }
                    catch (DateTimeParseException value3) {
                        try {
                            LocalDate value4 = LocalDate.parse(lineComponents[i], DateTimeFormatter.ofPattern("M/d/yyyy"));
                            rowData[i] = value4;
                            continue;
                        }
                        catch (DateTimeParseException value4) {
                            try {
                                LocalDate value5 = LocalDate.parse(lineComponents[i], DateTimeFormatter.ofPattern("MM/d/yyyy"));
                                rowData[i] = value5;
                                continue;
                            }
                            catch (DateTimeParseException value5) {
                                try {
                                    LocalDate value6 = LocalDate.parse(lineComponents[i], DateTimeFormatter.ofPattern("M/dd/yyyy"));
                                    rowData[i] = value6;
                                    continue;
                                }
                                catch (DateTimeParseException value6) {
                                    try {
                                        LocalDateTime value7 = LocalDateTime.parse(lineComponents[i], DateTimeFormatter.ofPattern("MM/dd/yyyy HH:mm:ss"));
                                        rowData[i] = value7;
                                        continue;
                                    }
                                    catch (DateTimeParseException value7) {
                                        try {
                                            LocalDateTime value8 = LocalDateTime.parse(lineComponents[i], DateTimeFormatter.ofPattern("M/dd/yyyy HH:mm:ss"));
                                            rowData[i] = value8;
                                            continue;
                                        }
                                        catch (DateTimeParseException value8) {
                                            try {
                                                LocalDateTime value9 = LocalDateTime.parse(lineComponents[i], DateTimeFormatter.ofPattern("MM/d/yyyy HH:mm:ss"));
                                                rowData[i] = value9;
                                                continue;
                                            }
                                            catch (DateTimeParseException value9) {
                                                try {
                                                    LocalDateTime value10 = LocalDateTime.parse(lineComponents[i], DateTimeFormatter.ofPattern("M/d/yyyy HH:mm:ss"));
                                                    rowData[i] = value10;
                                                    continue;
                                                }
                                                catch (DateTimeParseException value10) {
                                                    try {
                                                        LocalDateTime value11 = LocalDateTime.parse(lineComponents[i], DateTimeFormatter.ofPattern("MM/dd/yyyy HH:mm"));
                                                        rowData[i] = value11;
                                                        continue;
                                                    }
                                                    catch (DateTimeParseException value11) {
                                                        try {
                                                            LocalDateTime value12 = LocalDateTime.parse(lineComponents[i], DateTimeFormatter.ofPattern("M/dd/yyyy HH:mm"));
                                                            rowData[i] = value12;
                                                            continue;
                                                        }
                                                        catch (DateTimeParseException value12) {
                                                            try {
                                                                LocalDateTime value13 = LocalDateTime.parse(lineComponents[i], DateTimeFormatter.ofPattern("MM/d/yyyy HH:mm"));
                                                                rowData[i] = value13;
                                                                continue;
                                                            }
                                                            catch (DateTimeParseException value13) {
                                                                try {
                                                                    LocalDateTime value14 = LocalDateTime.parse(lineComponents[i], DateTimeFormatter.ofPattern("M/d/yyyy HH:mm"));
                                                                    rowData[i] = value14;
                                                                    continue;
                                                                }
                                                                catch (DateTimeParseException value14) {
                                                                    try {
                                                                        LocalDateTime value15 = LocalDateTime.parse(lineComponents[i], DateTimeFormatter.ofPattern("MM/dd/yyyy@HH:mm:ss"));
                                                                        rowData[i] = value15;
                                                                        continue;
                                                                    }
                                                                    catch (DateTimeParseException value15) {
                                                                        try {
                                                                            LocalDateTime value16 = LocalDateTime.parse(lineComponents[i], DateTimeFormatter.ofPattern("MM/d/yyyy@HH:mm:ss"));
                                                                            rowData[i] = value16;
                                                                            continue;
                                                                        }
                                                                        catch (DateTimeParseException value16) {
                                                                            try {
                                                                                LocalDateTime value17 = LocalDateTime.parse(lineComponents[i], DateTimeFormatter.ofPattern("M/dd/yyyy@HH:mm:ss"));
                                                                                rowData[i] = value17;
                                                                                continue;
                                                                            }
                                                                            catch (DateTimeParseException value17) {
                                                                                try {
                                                                                    LocalDateTime value18 = LocalDateTime.parse(lineComponents[i], DateTimeFormatter.ofPattern("M/d/yyyy@HH:mm:ss"));
                                                                                    rowData[i] = value18;
                                                                                    continue;
                                                                                }
                                                                                catch (DateTimeParseException value18) {
                                                                                    try {
                                                                                        LocalDateTime value19 = LocalDateTime.parse(lineComponents[i], DateTimeFormatter.ofPattern("MM/dd/yyyy@HH:mm"));
                                                                                        rowData[i] = value19;
                                                                                        continue;
                                                                                    }
                                                                                    catch (DateTimeParseException value19) {
                                                                                        try {
                                                                                            LocalDateTime value20 = LocalDateTime.parse(lineComponents[i], DateTimeFormatter.ofPattern("M/dd/yyyy@HH:mm"));
                                                                                            rowData[i] = value20;
                                                                                            continue;
                                                                                        }
                                                                                        catch (DateTimeParseException value20) {
                                                                                            try {
                                                                                                LocalDateTime value21 = LocalDateTime.parse(lineComponents[i], DateTimeFormatter.ofPattern("MM/d/yyyy@HH:mm"));
                                                                                                rowData[i] = value21;
                                                                                                continue;
                                                                                            }
                                                                                            catch (DateTimeParseException value21) {
                                                                                                try {
                                                                                                    LocalDateTime value22 = LocalDateTime.parse(lineComponents[i], DateTimeFormatter.ofPattern("M/d/yyyy@HH:mm"));
                                                                                                    rowData[i] = value22;
                                                                                                    continue;
                                                                                                }
                                                                                                catch (DateTimeParseException dateTimeParseException) {
                                                                                                    rowData[i] = lineComponents[i];
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return rowData;
    }

    @Override
    public synchronized void addProgressListener(ProgressListener listener) {
        this.progressListeners.add(listener);
    }

    @Override
    public synchronized void removeProgressListener(ProgressListener listener) {
        this.progressListeners.remove(listener);
    }

    private synchronized void updateAmountDone(int dataProcessed) {
        this.amountDone += (long)dataProcessed;
        this.setProgress(Math.min((int)(100.0 * (double)this.amountDone / (double)this.totalAmountToDo), 99));
    }

    private synchronized void setAmountDone(int dataProcessed) {
        this.amountDone = dataProcessed;
    }

    private synchronized void setProgress(int progress) {
        this.progress = progress;
        for (ProgressListener listener : this.progressListeners) {
            listener.progressUpdated(new ProgressUpdateEvent(this.getCurrentOperation(), this.getProgress(), this.getAmountDone(), this.getTotalAmountToDo()));
        }
    }

    private synchronized int getProgress() {
        return this.progress;
    }

    public synchronized long getAmountDone() {
        return this.amountDone;
    }

    public synchronized long getTotalAmountToDo() {
        return this.totalAmountToDo;
    }

    public synchronized String getCurrentOperation() {
        return this.operationName;
    }

    private synchronized void setCurrentOperation(String operation) {
        this.operationName = operation;
        for (ProgressListener listener : this.progressListeners) {
            listener.progressUpdated(new ProgressUpdateEvent(this.getCurrentOperation(), this.getProgress(), this.getAmountDone(), this.getTotalAmountToDo()));
        }
    }

    @Override
    public ArrayList<Object[]> call() throws IOException, IllegalArgumentException, IndexOutOfBoundsException, InterruptedException {
        return this.processReport();
    }
}

