/*
 * Decompiled with CFR 0.152.
 */
package com.verdegraphics.kidneycalc;

import com.verdegraphics.kidneycalc.Sex;

public class WeightCalculator {
    private static final double BODY_MASS_INDEX_LOWER_CUTOFF = 17.5;
    private static final double BODY_MASS_INDEX_UPPER_CUTOFF = 40.0;
    private static final double[][] CHILD_BMI_FOR_AGE_95_PERCENTILE_MALE = new double[][]{{2.0, 19.2}, {2.5, 18.8}, {3.0, 18.2}, {3.5, 18.0}, {4.0, 17.8}, {5.0, 17.8}, {5.5, 18.2}, {6.0, 18.4}, {6.5, 18.8}, {7.0, 19.2}, {7.5, 19.6}, {8.0, 20.0}, {8.5, 20.6}, {9.0, 21.0}, {9.5, 21.6}, {10.0, 22.1}, {10.5, 22.6}, {11.0, 23.2}, {11.5, 23.7}, {12.0, 24.2}, {12.5, 24.7}, {13.0, 25.2}, {13.5, 25.6}, {14.0, 26.0}, {14.5, 26.4}, {15.0, 26.8}, {15.5, 27.2}, {16.0, 27.6}, {16.5, 27.9}, {17.0, 28.2}, {17.5, 28.6}, {18.0, 28.9}, {18.5, 29.3}, {19.0, 29.7}, {19.5, 30.1}, {20.0, 30.6}};
    private static final double[][] CHILD_BMI_FOR_AGE_5_PERCENTILE_MALE = new double[][]{{2.0, 14.8}, {2.5, 14.5}, {3.0, 14.4}, {3.5, 14.2}, {4.0, 14.0}, {4.5, 13.9}, {5.0, 13.8}, {5.5, 13.8}, {6.0, 13.7}, {6.5, 13.7}, {7.0, 13.7}, {7.5, 13.8}, {8.0, 13.8}, {8.5, 13.9}, {9.0, 14.0}, {9.5, 14.1}, {10.0, 14.2}, {10.5, 14.4}, {11.0, 14.6}, {11.5, 14.8}, {12.0, 15.0}, {12.5, 15.2}, {13.0, 15.4}, {13.5, 15.7}, {14.0, 16.0}, {14.5, 16.2}, {15.0, 16.6}, {15.5, 16.8}, {16.0, 17.1}, {16.5, 17.4}, {17.0, 17.7}, {17.5, 18.0}, {18.0, 18.2}, {18.5, 18.5}, {19.0, 18.7}, {19.5, 18.9}, {20.0, 19.1}};
    private static final double[][] CHILD_BMI_FOR_AGE_95_PERCENTILE_FEMALE = new double[][]{{2.0, 19.1}, {2.5, 18.6}, {3.0, 18.3}, {3.5, 18.1}, {4.0, 18.0}, {4.5, 18.1}, {5.0, 18.2}, {5.5, 18.7}, {6.0, 18.8}, {6.5, 19.2}, {7.0, 19.6}, {7.5, 20.2}, {8.0, 20.6}, {8.5, 21.2}, {9.0, 21.8}, {9.5, 22.4}, {10.0, 23.0}, {10.5, 23.5}, {11.0, 24.1}, {11.5, 24.7}, {12.0, 25.2}, {12.5, 25.8}, {13.0, 26.2}, {13.5, 26.8}, {14.0, 27.2}, {14.5, 27.6}, {15.0, 28.1}, {15.5, 28.5}, {16.0, 289.0}, {16.5, 29.2}, {17.0, 29.8}, {17.5, 30.0}, {18.0, 30.3}, {18.5, 30.6}, {19.0, 31.0}, {19.5, 31.4}, {20.0, 31.8}};
    private static final double[][] CHILD_BMI_FOR_AGE_5_PERCENTILE_FEMALE = new double[][]{{2.0, 14.4}, {2.5, 14.2}, {3.0, 14.0}, {3.5, 13.8}, {4.0, 13.7}, {4.5, 13.6}, {5.0, 13.5}, {5.5, 13.5}, {6.0, 13.4}, {6.5, 13.4}, {7.0, 13.4}, {7.5, 13.5}, {8.0, 13.5}, {8.5, 13.6}, {9.0, 13.7}, {9.5, 13.9}, {10.0, 14.0}, {10.5, 14.2}, {11.0, 14.4}, {11.5, 14.6}, {12.0, 14.8}, {12.5, 15.0}, {13.0, 15.3}, {13.5, 15.6}, {14.0, 15.8}, {14.5, 16.0}, {15.0, 16.3}, {15.5, 16.5}, {16.0, 16.8}, {16.5, 17.0}, {17.0, 17.2}, {17.5, 17.4}, {18.0, 17.6}, {18.5, 17.7}, {19.0, 17.8}, {19.5, 17.8}, {20.0, 17.8}};
    private static final double[][] INFANT_HEIGHT_WEIGHT_95_PERCENTILE_MALE = new double[][]{{45.0, 2.850807}, {45.5, 2.946724}, {46.0, 3.042427}, {46.5, 3.138329}, {47.0, 3.234886}, {47.5, 3.332742}, {48.0, 3.43248}, {48.5, 3.53508}, {49.0, 3.641592}, {49.5, 3.752297}, {50.0, 3.86684}, {50.5, 3.984869}, {51.0, 4.106421}, {51.5, 4.232023}, {52.0, 4.362364}, {52.5, 4.49848}, {53.0, 4.640477}, {53.5, 4.787883}, {54.0, 4.940342}, {54.5, 5.096575}, {55.0, 5.255972}, {55.5, 5.417981}, {56.0, 5.582349}, {56.5, 5.747942}, {57.0, 5.914155}, {57.5, 6.080102}, {58.0, 6.245662}, {58.5, 6.410382}, {59.0, 6.573927}, {59.5, 6.735847}, {60.0, 6.89535}, {60.5, 7.05165}, {61.0, 7.204766}, {61.5, 7.354806}, {62.0, 7.502278}, {62.5, 7.647269}, {63.0, 7.79051}, {63.5, 7.931881}, {64.0, 8.071618}, {64.5, 8.209873}, {65.0, 8.346744}, {65.5, 8.482471}, {66.0, 8.617553}, {66.5, 8.751853}, {67.0, 8.885379}, {67.5, 9.018137}, {68.0, 9.150293}, {68.5, 9.281768}, {69.0, 9.413071}, {69.5, 9.544487}, {70.0, 9.675696}, {70.5, 9.806637}, {71.0, 9.936572}, {71.5, 10.06579}, {72.0, 10.19359}, {72.5, 10.3204}, {73.0, 10.44546}, {73.5, 10.56882}, {74.0, 10.69049}, {74.5, 10.81073}, {75.0, 10.92939}, {75.5, 11.04658}, {76.0, 11.16183}, {76.5, 11.27465}, {77.0, 11.38522}, {77.5, 11.49384}, {78.0, 11.60047}, {78.5, 11.70563}, {79.0, 11.80969}, {79.5, 11.91365}, {80.0, 12.0181}, {80.5, 12.12362}, {81.0, 12.23085}, {81.5, 12.34049}, {82.0, 12.45299}, {82.5, 12.56846}, {83.0, 12.6878}, {83.5, 12.811}, {84.0, 12.93781}, {84.5, 13.06789}, {85.0, 13.20064}, {85.5, 13.3355}, {86.0, 13.47199}, {86.5, 13.60955}, {87.0, 13.74748}, {87.5, 13.88559}, {88.0, 14.02317}, {88.5, 14.1599}, {89.0, 14.29604}, {89.5, 14.43122}, {90.0, 14.56597}, {90.5, 14.69965}, {91.0, 14.83338}, {91.5, 14.96664}, {92.0, 15.10008}, {92.5, 15.23344}, {93.0, 15.36695}, {93.5, 15.50112}, {94.0, 15.63618}, {94.5, 15.77223}, {95.0, 15.90949}, {95.5, 16.04848}, {96.0, 16.18957}, {96.5, 16.33231}, {97.0, 16.47814}, {97.5, 16.6261}, {98.0, 16.77723}, {98.5, 16.93104}, {99.0, 17.08775}, {99.5, 17.24756}, {100.0, 17.41019}, {100.5, 17.57543}, {101.0, 17.74339}, {101.5, 17.91387}, {102.0, 18.08698}, {102.5, 18.26231}, {103.0, 18.44018}, {103.5, 18.62048}, {104.0, 18.8028}, {104.5, 18.98757}, {105.0, 19.17436}, {105.5, 19.36341}, {106.0, 19.55494}, {106.5, 19.74885}, {107.0, 19.94503}, {107.5, 20.14419}, {108.0, 20.34528}, {108.5, 20.54925}, {109.0, 20.75587}, {109.5, 20.96574}, {110.0, 21.1785}};
    private static final double[][] INFANT_HEIGHT_WEIGHT_5_PERCENTILE_MALE = new double[][]{{45.0, 2.106981}, {45.5, 2.179956}, {46.0, 2.252911}, {46.5, 2.326226}, {47.0, 2.400092}, {47.5, 2.475063}, {48.0, 2.551572}, {48.5, 2.630444}, {49.0, 2.712292}, {49.5, 2.79742}, {50.0, 2.885574}, {50.5, 2.976497}, {51.0, 3.070327}, {51.5, 3.167371}, {52.0, 3.268154}, {52.5, 3.373464}, {53.0, 3.483394}, {53.5, 3.597603}, {54.0, 3.715835}, {54.5, 3.837139}, {55.0, 3.960933}, {55.5, 4.086931}, {56.0, 4.214808}, {56.5, 4.343844}, {57.0, 4.473289}, {57.5, 4.602751}, {58.0, 4.731982}, {58.5, 4.860627}, {59.0, 4.988415}, {59.5, 5.114823}, {60.0, 5.239396}, {60.5, 5.36134}, {61.0, 5.480644}, {61.5, 5.597732}, {62.0, 5.71242}, {62.5, 5.825317}, {63.0, 5.936584}, {63.5, 6.046305}, {64.0, 6.15465}, {64.5, 6.261515}, {65.0, 6.367164}, {65.5, 6.471767}, {66.0, 6.57548}, {66.5, 6.678396}, {67.0, 6.78051}, {67.5, 6.881819}, {68.0, 6.982208}, {68.5, 7.082064}, {69.0, 7.181539}, {69.5, 7.2806}, {70.0, 7.379471}, {70.5, 7.477858}, {71.0, 7.575438}, {71.5, 7.672178}, {72.0, 7.768056}, {72.5, 7.862618}, {73.0, 7.956055}, {73.5, 8.048159}, {74.0, 8.138929}, {74.5, 8.228845}, {75.0, 8.317519}, {75.5, 8.405039}, {76.0, 8.491054}, {76.5, 8.575747}, {77.0, 8.658991}, {77.5, 8.740739}, {78.0, 8.821532}, {78.5, 8.9015}, {79.0, 8.981224}, {79.5, 9.061183}, {80.0, 9.142137}, {80.5, 9.22453}, {81.0, 9.308575}, {81.5, 9.394803}, {82.0, 9.483891}, {82.5, 9.575937}, {83.0, 9.671326}, {83.5, 9.770064}, {84.0, 9.871983}, {84.5, 9.976826}, {85.0, 10.08383}, {85.5, 10.19289}, {86.0, 10.30333}, {86.5, 10.41437}, {87.0, 10.52582}, {87.5, 10.63682}, {88.0, 10.74717}, {88.5, 10.85661}, {89.0, 10.96496}, {89.5, 11.0723}, {90.0, 11.17826}, {90.5, 11.28346}, {91.0, 11.38761}, {91.5, 11.49143}, {92.0, 11.59427}, {92.5, 11.69667}, {93.0, 11.79879}, {93.5, 11.90063}, {94.0, 12.00234}, {94.5, 12.10437}, {95.0, 12.2069}, {95.5, 12.30989}, {96.0, 12.41361}, {96.5, 12.51852}, {97.0, 12.62446}, {97.5, 12.73194}, {98.0, 12.8409}, {98.5, 12.95136}, {99.0, 13.06348}, {99.5, 13.17696}, {100.0, 13.292}, {100.5, 13.40842}, {101.0, 13.5263}, {101.5, 13.64546}, {102.0, 13.76597}, {102.5, 13.88796}, {103.0, 14.01121}, {103.5, 14.13562}, {104.0, 14.26132}, {104.5, 14.38817}, {105.0, 14.51631}, {105.5, 14.6459}, {106.0, 14.77663}, {106.5, 14.90889}, {107.0, 15.0426}, {107.5, 15.17728}, {108.0, 15.31363}, {108.5, 15.45136}, {109.0, 15.59077}, {109.5, 15.7318}, {110.0, 15.87468}};
    private static final double[][] INFANT_HEIGHT_WEIGHT_95_PERCENTILE_FEMALE = new double[][]{{45.0, 2.867253}, {45.5, 2.966503}, {46.0, 3.065651}, {46.5, 3.164758}, {47.0, 3.264281}, {47.5, 3.364751}, {48.0, 3.466867}, {48.5, 3.571445}, {49.0, 3.679418}, {49.5, 3.791604}, {50.0, 3.908237}, {50.5, 4.029667}, {51.0, 4.155778}, {51.5, 4.286455}, {52.0, 4.421777}, {52.5, 4.561358}, {53.0, 4.704809}, {53.5, 4.852097}, {54.0, 5.00224}, {54.5, 5.154738}, {55.0, 5.309008}, {55.5, 5.464466}, {56.0, 5.620645}, {56.5, 5.777096}, {57.0, 5.933551}, {57.5, 6.089804}, {58.0, 6.24573}, {58.5, 6.400851}, {59.0, 6.554815}, {59.5, 6.707039}, {60.0, 6.857516}, {60.5, 7.006131}, {61.0, 7.152759}, {61.5, 7.297508}, {62.0, 7.440617}, {62.5, 7.581605}, {63.0, 7.720949}, {63.5, 7.858882}, {64.0, 7.995382}, {64.5, 8.130467}, {65.0, 8.264111}, {65.5, 8.396335}, {66.0, 8.526991}, {66.5, 8.656259}, {67.0, 8.783722}, {67.5, 8.909763}, {68.0, 9.033992}, {68.5, 9.156954}, {69.0, 9.27845}, {69.5, 9.398919}, {70.0, 9.518151}, {70.5, 9.636192}, {71.0, 9.753509}, {71.5, 9.870218}, {72.0, 9.985913}, {72.5, 10.10082}, {73.0, 10.21478}, {73.5, 10.32754}, {74.0, 10.43847}, {74.5, 10.54816}, {75.0, 10.65612}, {75.5, 10.76308}, {76.0, 10.86878}, {76.5, 10.97399}, {77.0, 11.07925}, {77.5, 11.18499}, {78.0, 11.29176}, {78.5, 11.40021}, {79.0, 11.51029}, {79.5, 11.62277}, {80.0, 11.73778}, {80.5, 11.85579}, {81.0, 11.97656}, {81.5, 12.10066}, {82.0, 12.22742}, {82.5, 12.35716}, {83.0, 12.48967}, {83.5, 12.62461}, {84.0, 12.76219}, {84.5, 12.90185}, {85.0, 13.04369}, {85.5, 13.18727}, {86.0, 13.33201}, {86.5, 13.47802}, {87.0, 13.62461}, {87.5, 13.77109}, {88.0, 13.91769}, {88.5, 14.06419}, {89.0, 14.21035}, {89.5, 14.3562}, {90.0, 14.50182}, {90.5, 14.647}, {91.0, 14.79221}, {91.5, 14.93748}, {92.0, 15.08277}, {92.5, 15.2282}, {93.0, 15.37381}, {93.5, 15.52006}, {94.0, 15.66671}, {94.5, 15.81397}, {95.0, 15.96212}, {95.5, 16.11153}, {96.0, 16.26169}, {96.5, 16.41294}, {97.0, 16.56557}, {97.5, 16.71965}, {98.0, 16.8756}, {98.5, 17.03365}, {99.0, 17.19368}, {99.5, 17.35648}, {100.0, 17.52161}, {100.5, 17.69022}, {101.0, 17.86129}, {101.5, 18.03555}, {102.0, 18.21325}, {102.5, 18.39363}, {103.0, 18.57791}, {103.5, 18.76476}, {104.0, 18.95508}, {104.5, 19.14865}, {105.0, 19.34491}, {105.5, 19.54466}, {106.0, 19.74792}, {106.5, 19.95423}, {107.0, 20.16441}, {107.5, 20.378}, {108.0, 20.5956}, {108.5, 20.81637}, {109.0, 21.04105}, {109.5, 21.26916}, {110.0, 21.50047}};
    private static final double[][] INFANT_HEIGHT_WEIGHT_5_PERCENTILE_FEMALE = new double[][]{{45.0, 2.129751}, {45.5, 2.203182}, {46.0, 2.276517}, {46.5, 2.34988}, {47.0, 2.423458}, {47.5, 2.497718}, {48.0, 2.573181}, {48.5, 2.650451}, {49.0, 2.730221}, {49.5, 2.813094}, {50.0, 2.899244}, {50.5, 2.98893}, {51.0, 3.082063}, {51.5, 3.178559}, {52.0, 3.278363}, {52.5, 3.381404}, {53.0, 3.487286}, {53.5, 3.595865}, {54.0, 3.706646}, {54.5, 3.819142}, {55.0, 3.932921}, {55.5, 4.04755}, {56.0, 4.162683}, {56.5, 4.278128}, {57.0, 4.393408}, {57.5, 4.508656}, {58.0, 4.623793}, {58.5, 4.738318}, {59.0, 4.851972}, {59.5, 4.964486}, {60.0, 5.075701}, {60.5, 5.185529}, {61.0, 5.294055}, {61.5, 5.401368}, {62.0, 5.507474}, {62.5, 5.612202}, {63.0, 5.715727}, {63.5, 5.818222}, {64.0, 5.919864}, {64.5, 6.020479}, {65.0, 6.120247}, {65.5, 6.218991}, {66.0, 6.316808}, {66.5, 6.413417}, {67.0, 6.508928}, {67.5, 6.603417}, {68.0, 6.696814}, {68.5, 6.789085}, {69.0, 6.880527}, {69.5, 6.971011}, {70.0, 7.060842}, {70.5, 7.149824}, {71.0, 7.238303}, {71.5, 7.326367}, {72.0, 7.413956}, {72.5, 7.500756}, {73.0, 7.586879}, {73.5, 7.672153}, {74.0, 7.756351}, {74.5, 7.839407}, {75.0, 7.921476}, {75.5, 8.002572}, {76.0, 8.08303}, {76.5, 8.163159}, {77.0, 8.24309}, {77.5, 8.323686}, {78.0, 8.405079}, {78.5, 8.487483}, {79.0, 8.571423}, {79.5, 8.656893}, {80.0, 8.744286}, {80.5, 8.833949}, {81.0, 8.925709}, {81.5, 9.019686}, {82.0, 9.115672}, {82.5, 9.21361}, {83.0, 9.313642}, {83.5, 9.415507}, {84.0, 9.519058}, {84.5, 9.624179}, {85.0, 9.730633}, {85.5, 9.838068}, {86.0, 9.946702}, {86.5, 10.05564}, {87.0, 10.16501}, {87.5, 10.27429}, {88.0, 10.38332}, {88.5, 10.49193}, {89.0, 10.60026}, {89.5, 10.708}, {90.0, 10.81555}, {90.5, 10.92274}, {91.0, 11.02957}, {91.5, 11.13605}, {92.0, 11.24251}, {92.5, 11.34904}, {93.0, 11.45529}, {93.5, 11.56159}, {94.0, 11.66814}, {94.5, 11.77509}, {95.0, 11.88227}, {95.5, 11.98993}, {96.0, 12.09808}, {96.5, 12.20698}, {97.0, 12.31643}, {97.5, 12.42689}, {98.0, 12.53825}, {98.5, 12.65066}, {99.0, 12.76488}, {99.5, 12.88022}, {100.0, 12.99761}, {100.5, 13.11663}, {101.0, 13.23779}, {101.5, 13.36076}, {102.0, 13.48572}, {102.5, 13.613}, {103.0, 13.74212}, {103.5, 13.87346}, {104.0, 14.00677}, {104.5, 14.14187}, {105.0, 14.27927}, {105.5, 14.41863}, {106.0, 14.55992}, {106.5, 14.70378}, {107.0, 14.84983}, {107.5, 14.99821}, {108.0, 15.14886}, {108.5, 15.30215}, {109.0, 15.45761}, {109.5, 15.61539}, {110.0, 15.77532}};

    public static double calculateBMI(double height, double weight) {
        return weight / Math.pow(height / 100.0, 2.0);
    }

    public static double calculateIdealBodyWeight(double age, double height, Sex sex) {
        if (height / 2.54 < 60.0) {
            if (age <= 10.0) {
                return 8.0 + 2.0 * age;
            }
            return (sex == Sex.MALE ? 21.53 : 19.59) * Math.pow(height / 100.0, 2.0);
        }
        return (sex == Sex.MALE ? 50.0 : 45.5) + 2.3 * (height / 2.54 - 60.0);
    }

    public static double calculateAdjustedBodyWeight(double age, double height, double weight, Sex sex) {
        double idealBodyWeight = WeightCalculator.calculateIdealBodyWeight(age, height, sex);
        return idealBodyWeight + 0.4 * (weight - idealBodyWeight);
    }

    public static boolean isNormalBMI(double age, double height, double weight, Sex sex) {
        double bmi = WeightCalculator.calculateBMI(height, weight);
        if (age < 2.0) {
            double roundedHeight = Math.round(height * 2.0) / 2L;
            int index = (int)(roundedHeight * 2.0) - 90;
            try {
                if (sex == Sex.MALE) {
                    return !(weight > INFANT_HEIGHT_WEIGHT_95_PERCENTILE_MALE[index][1]) && !(weight < INFANT_HEIGHT_WEIGHT_5_PERCENTILE_MALE[index][1]);
                }
                return !(weight > INFANT_HEIGHT_WEIGHT_95_PERCENTILE_FEMALE[index][1]) && !(weight < INFANT_HEIGHT_WEIGHT_5_PERCENTILE_FEMALE[index][1]);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return false;
            }
        }
        if (age < 20.0) {
            double roundedAge = Math.round(age * 2.0) / 2L;
            int index = (int)(roundedAge * 2.0) - 4;
            if (sex == Sex.MALE) {
                return !(bmi > CHILD_BMI_FOR_AGE_95_PERCENTILE_MALE[index][1]) && !(bmi < CHILD_BMI_FOR_AGE_5_PERCENTILE_MALE[index][1]);
            }
            return !(bmi > CHILD_BMI_FOR_AGE_95_PERCENTILE_FEMALE[index][1]) && !(bmi < CHILD_BMI_FOR_AGE_5_PERCENTILE_FEMALE[index][1]);
        }
        return !(bmi > 40.0) && !(bmi < 17.5);
    }
}

