/*
 * Decompiled with CFR 0.152.
 */
package com.verdegraphics.kidneycalc;

import com.verdegraphics.kidneycalc.Sex;
import com.verdegraphics.kidneycalc.TUIMenu;
import java.util.Scanner;

public class TUIInputPrompt
extends TUIMenu {
    private static final Scanner SCANNER = new Scanner(System.in);
    private static final int INDENT = 5;
    private static final int MY_TEXT_WIDTH = 46;

    private TUIInputPrompt() {
    }

    private static String indent() {
        String indent = "";
        for (int i = 0; i < 5; ++i) {
            indent = indent.concat(" ");
        }
        return indent;
    }

    public static double getAge(TUIMenu menu) {
        double age = 0.0;
        while (true) {
            System.out.print("Age: ");
            String line = SCANNER.nextLine();
            if (line.equalsIgnoreCase("^")) break;
            try {
                if (line.toUpperCase().contains("M")) {
                    line = line.substring(0, line.toUpperCase().indexOf("M"));
                    age = Double.parseDouble(line) / 12.0;
                } else {
                    age = Double.parseDouble(line);
                }
                menu.incrementMenuIndex();
                return age;
            }
            catch (NumberFormatException e) {
                System.out.println(TUIInputPrompt.generateIndentedTextWidthString(5, 46, TUIInputPrompt.indent() + "Enter a numeric age in years, or type a number followed by m to give age in months."));
                continue;
            }
            break;
        }
        menu.decrementMenuIndex();
        return age;
    }

    public static Sex getSex(TUIMenu menu) {
        Sex sex = null;
        while (true) {
            System.out.print("Sex: ");
            String line = SCANNER.nextLine().toLowerCase();
            if (line.equalsIgnoreCase("^")) {
                menu.decrementMenuIndex();
                break;
            }
            if (line.contains("f")) {
                sex = Sex.FEMALE;
                menu.incrementMenuIndex();
                break;
            }
            if (line.contains("m")) {
                sex = Sex.MALE;
                menu.incrementMenuIndex();
                break;
            }
            System.out.println(TUIInputPrompt.generateIndentedTextWidthString(5, 46, TUIInputPrompt.indent() + "Enter male or female."));
        }
        return sex;
    }

    public static double getSerumCreatinine(TUIMenu menu) {
        double serumCreatinine = 0.0;
        while (true) {
            System.out.print("SCr: ");
            String line = SCANNER.nextLine();
            if (line.equalsIgnoreCase("^")) {
                menu.decrementMenuIndex();
                break;
            }
            try {
                serumCreatinine = Double.parseDouble(line);
                menu.incrementMenuIndex();
            }
            catch (NumberFormatException e) {
                System.out.println(TUIInputPrompt.generateIndentedTextWidthString(5, 46, TUIInputPrompt.indent() + "Enter a numeric serum creatinine in mg/dL."));
                continue;
            }
            break;
        }
        return serumCreatinine;
    }

    public static double getHeight(TUIMenu menu) {
        double height = 0.0;
        while (true) {
            System.out.print(" Ht: ");
            String line = SCANNER.nextLine();
            if (line.equalsIgnoreCase("^")) {
                menu.decrementMenuIndex();
                break;
            }
            if (line.isEmpty()) {
                System.out.println(TUIInputPrompt.generateIndentedTextWidthString(5, 46, TUIInputPrompt.indent() + "Will try to estimate renal function without a height."));
                menu.incrementMenuIndex();
                break;
            }
            try {
                height = Double.parseDouble(line);
                menu.incrementMenuIndex();
            }
            catch (NumberFormatException e) {
                System.out.println(TUIInputPrompt.generateIndentedTextWidthString(5, 46, TUIInputPrompt.indent() + "Enter a numeric height in centimeters."));
                continue;
            }
            break;
        }
        return height;
    }

    public static double getWeight(TUIMenu menu) {
        double weight = 0.0;
        while (true) {
            System.out.print(" Wt: ");
            String line = SCANNER.nextLine();
            if (line.equalsIgnoreCase("^")) {
                menu.decrementMenuIndex();
                break;
            }
            try {
                weight = Double.parseDouble(line);
                menu.incrementMenuIndex();
            }
            catch (NumberFormatException e) {
                System.out.println(TUIInputPrompt.generateIndentedTextWidthString(5, 46, TUIInputPrompt.indent() + "Enter a numeric weight in kilograms."));
                continue;
            }
            break;
        }
        return weight;
    }

    public static boolean getStableRenalFunction(TUIMenu menu) {
        boolean stableRenalFunction = true;
        while (true) {
            System.out.print("AKI? ");
            String line = SCANNER.nextLine().toLowerCase();
            if (line.equalsIgnoreCase("^")) {
                menu.decrementMenuIndex();
                break;
            }
            if (line.contains("y")) {
                stableRenalFunction = false;
                menu.incrementMenuIndex();
                break;
            }
            if (line.contains("n")) {
                stableRenalFunction = true;
                menu.incrementMenuIndex();
                break;
            }
            System.out.println(TUIInputPrompt.generateIndentedTextWidthString(5, 51, TUIInputPrompt.indent() + "Does the patient have unstable renal function or AKI? Enter yes or no."));
        }
        return stableRenalFunction;
    }
}

