/*
 * Decompiled with CFR 0.152.
 */
package com.verdegraphics.kidneycalc;

import com.verdegraphics.analyticsreporter.AnalyticsReporter;
import com.verdegraphics.kidneycalc.BSACalculator;
import com.verdegraphics.kidneycalc.BedsideSchwartzCalculator;
import com.verdegraphics.kidneycalc.BedsideSchwartzCalculatorTUI;
import com.verdegraphics.kidneycalc.Calculator;
import com.verdegraphics.kidneycalc.CalculatorTUI;
import com.verdegraphics.kidneycalc.CalculatorTUIMenuItem;
import com.verdegraphics.kidneycalc.CockroftGaultCalculator;
import com.verdegraphics.kidneycalc.CockroftGaultCalculatorTUI;
import com.verdegraphics.kidneycalc.KidneyCalculator;
import com.verdegraphics.kidneycalc.TUIInputPrompt;
import com.verdegraphics.kidneycalc.WeightCalculator;

public final class TUI
extends CalculatorTUI {
    private final CalculatorTUIMenuItem[] menuItems = new CalculatorTUIMenuItem[]{new CalculatorTUIMenuItem(){

        @Override
        public void setCalculatorWithInput(Calculator calculator) {
            KidneyCalculator myCalculator = (KidneyCalculator)calculator;
            myCalculator.setValueForParameter((Object)TUIInputPrompt.getAge(TUI.this), KidneyCalculator.Parameter.AGE);
        }
    }, new CalculatorTUIMenuItem(){

        @Override
        public void setCalculatorWithInput(Calculator calculator) {
            KidneyCalculator myCalculator = (KidneyCalculator)calculator;
            myCalculator.setValueForParameter((Object)TUIInputPrompt.getSex(TUI.this), KidneyCalculator.Parameter.SEX);
        }
    }, new CalculatorTUIMenuItem(){

        @Override
        public void setCalculatorWithInput(Calculator calculator) {
            KidneyCalculator myCalculator = (KidneyCalculator)calculator;
            myCalculator.setValueForParameter((Object)TUIInputPrompt.getSerumCreatinine(TUI.this), KidneyCalculator.Parameter.SERUM_CREATININE);
        }
    }, new CalculatorTUIMenuItem(){

        @Override
        public void setCalculatorWithInput(Calculator calculator) {
            KidneyCalculator myCalculator = (KidneyCalculator)calculator;
            myCalculator.setValueForParameter((Object)TUIInputPrompt.getHeight(TUI.this), KidneyCalculator.Parameter.HEIGHT);
        }
    }, new CalculatorTUIMenuItem(){

        @Override
        public void setCalculatorWithInput(Calculator calculator) {
            KidneyCalculator myCalculator = (KidneyCalculator)calculator;
            myCalculator.setValueForParameter((Object)TUIInputPrompt.getWeight(TUI.this), KidneyCalculator.Parameter.WEIGHT);
        }
    }, new CalculatorTUIMenuItem(){

        @Override
        public void setCalculatorWithInput(Calculator calculator) {
            KidneyCalculator myCalculator = (KidneyCalculator)calculator;
            myCalculator.setValueForParameter((Object)TUIInputPrompt.getStableRenalFunction(TUI.this), KidneyCalculator.Parameter.STABLE_RENAL_FUNCTION);
        }
    }};

    public TUI() {
        this.calculator = new KidneyCalculator();
        this.showTUI();
    }

    private void showTUI() {
        System.out.println("  _  ___     _                   ____      _      \n | |/ (_) __| |_ __   ___ _   _ / ___|__ _| | ___ \n | ' /| |/ _` | '_ \\ / _ \\ | | | |   / _` | |/ __|\n | . \\| | (_| | | | |  __/ |_| | |__| (_| | | (__ \n |_|\\_\\_|\\__,_|_| |_|\\___|\\__, |\\____\\__,_|_|\\___|\n                          |___/                   ");
        String byline = "By LT Nick Stauffer";
        String version = "Version 0.4";
        System.out.print(byline);
        for (int i = 0; i < 51 - byline.length() - version.length(); ++i) {
            System.out.print(" ");
        }
        System.out.println(version);
        System.out.println("---------------------------------------------------");
        System.out.println();
        while (true) {
            if (this.menuIndex() < this.menuItems.length) {
                if (this.menuIndex() > -1) {
                    this.menuItems[this.menuIndex()].setCalculatorWithInput(this.calculator);
                    continue;
                }
                this.resetMenuIndex();
                continue;
            }
            this.displayCalculationParameters();
            this.displayCalculation();
            new Thread(new AnalyticsReporter("KidneyCalc", "0.4", "calculation performed")).start();
            String line = this.scanner.nextLine();
            if (line.equalsIgnoreCase("^")) {
                this.decrementMenuIndex();
                continue;
            }
            this.resetMenuIndex();
        }
    }

    private void displayCalculationParameters() {
        KidneyCalculator myCalculator = (KidneyCalculator)this.calculator;
        System.out.println();
        System.out.println("---------------------------------------------------");
        System.out.printf("Age: %s\tSex: %s\t  SCr: %.2f mg/dL\n", new Object[]{myCalculator.age() == Math.floor(myCalculator.age()) ? String.format("%.0f y", myCalculator.age()) : String.format("%.0f y %.0f m", Math.floor(myCalculator.age()), (myCalculator.age() - Math.floor(myCalculator.age())) * 12.0), myCalculator.sex(), myCalculator.serumCreatinine()});
        System.out.printf(" Ht: %s\t Wt: %.2f kg\t  BMI: %s\n", myCalculator.height() == 0.0 ? "\t" : String.format("%.2f cm", myCalculator.height()), myCalculator.weight(), myCalculator.height() == 0.0 ? "\t" : String.format("%.2f kg/m^2", WeightCalculator.calculateBMI(myCalculator.height(), myCalculator.weight())));
        System.out.printf("BSA: %s\tIBW: %s\tAdjBW: %s\n", myCalculator.height() == 0.0 ? "\t" : String.format("%.2f m^2", BSACalculator.calculateBSA(myCalculator.height(), myCalculator.weight())), myCalculator.height() == 0.0 && myCalculator.age() > 10.0 ? "\t" : String.format("%.2f kg", WeightCalculator.calculateIdealBodyWeight(myCalculator.age(), myCalculator.height(), myCalculator.sex())), myCalculator.height() == 0.0 && myCalculator.age() > 10.0 || WeightCalculator.calculateIdealBodyWeight(myCalculator.age(), myCalculator.height(), myCalculator.sex()) > myCalculator.weight() ? "\t" : String.format("%.2f kg", WeightCalculator.calculateAdjustedBodyWeight(myCalculator.age(), myCalculator.height(), myCalculator.weight(), myCalculator.sex())));
        System.out.printf("                Stable renal function: %s\n", myCalculator.stableRenalFunction() ? "Yes" : "No");
    }

    @Override
    protected void displayCalculation() {
        KidneyCalculator kidneyCalculator = (KidneyCalculator)this.calculator;
        Calculator[] preferredCalculators = kidneyCalculator.calculateUsingPreferredEquations();
        if (kidneyCalculator.disclaimers().size() > 0) {
            System.out.println();
            TUI.displayDisclaimers(kidneyCalculator.disclaimers);
        }
        block4: for (Calculator myCalculator : preferredCalculators) {
            System.out.println();
            switch (myCalculator.equation()) {
                case COCKROFT_GAULT: {
                    new CockroftGaultCalculatorTUI((CockroftGaultCalculator)myCalculator);
                    continue block4;
                }
                case BEDSIDE_SCHWARTZ: {
                    new BedsideSchwartzCalculatorTUI((BedsideSchwartzCalculator)myCalculator);
                }
            }
        }
        System.out.println("---------------------------------------------------");
    }
}

