/*
 * Decompiled with CFR 0.152.
 */
package com.verdegraphics.kidneycalc;

import com.verdegraphics.kidneycalc.BedsideSchwartzCalculator;
import com.verdegraphics.kidneycalc.Calculator;
import com.verdegraphics.kidneycalc.CalculatorParameter;
import com.verdegraphics.kidneycalc.CockroftGaultCalculator;
import com.verdegraphics.kidneycalc.Sex;
import com.verdegraphics.kidneycalc.WeightCalculator;
import java.util.ArrayList;

public class KidneyCalculator
extends Calculator<Parameter> {
    private double age;
    private double serumCreatinine;
    private double height;
    private double weight;
    private Sex sex;
    private boolean stableRenalFunction;

    @Override
    public void setValueForParameter(Object value, CalculatorParameter<Parameter> parameter) throws IllegalArgumentException {
        try {
            switch (parameter.getParameter()) {
                case AGE: {
                    this.setAge((Double)value);
                    break;
                }
                case SERUM_CREATININE: {
                    this.setSerumCreatinine((Double)value);
                    break;
                }
                case HEIGHT: {
                    this.setHeight((Double)value);
                    break;
                }
                case WEIGHT: {
                    this.setWeight((Double)value);
                    break;
                }
                case SEX: {
                    this.setSex((Sex)((Object)value));
                    break;
                }
                case STABLE_RENAL_FUNCTION: {
                    this.setStableRenalFunction((Boolean)value);
                }
            }
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private void setAge(double age) {
        this.age = age;
    }

    public double age() {
        return this.age;
    }

    private void setSerumCreatinine(double serumCreatinine) {
        this.serumCreatinine = serumCreatinine;
    }

    public double serumCreatinine() {
        return this.serumCreatinine;
    }

    private void setHeight(double height) {
        this.height = height;
    }

    public double height() {
        return this.height;
    }

    private void setWeight(double weight) {
        this.weight = weight;
    }

    public double weight() {
        return this.weight;
    }

    private void setSex(Sex sex) {
        this.sex = sex;
    }

    public Sex sex() {
        return this.sex;
    }

    public void setStableRenalFunction(boolean stableRenalFunction) {
        this.stableRenalFunction = stableRenalFunction;
    }

    public boolean stableRenalFunction() {
        return this.stableRenalFunction;
    }

    public Calculator[] calculateUsingPreferredEquations() {
        ArrayList<Calculator> calculators = new ArrayList<Calculator>();
        this.disclaimers.clear();
        if (this.height != 0.0 && !WeightCalculator.isNormalBMI(this.age, this.height, this.weight, this.sex)) {
            this.disclaimers.add("The patient is outside of 5th to 95th percentile range of BMI for age. Please verify that age, height, and weight are correct. Enter ^ to go back and edit, if necessary.");
        }
        calculators.add(new CockroftGaultCalculator(this.age, this.serumCreatinine, this.height, this.weight, this.sex, this.stableRenalFunction));
        if (this.age <= 18.0) {
            calculators.add(new BedsideSchwartzCalculator(this.age, this.serumCreatinine, this.height, this.stableRenalFunction));
        }
        if (!this.stableRenalFunction) {
            // empty if block
        }
        return calculators.toArray(new Calculator[0]);
    }

    @Override
    public double calculate() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public static enum Parameter implements CalculatorParameter<Parameter>
    {
        AGE,
        SERUM_CREATININE,
        HEIGHT,
        WEIGHT,
        SEX,
        STABLE_RENAL_FUNCTION;


        @Override
        public Parameter getParameter() {
            return this;
        }
    }
}

