/*
 * Decompiled with CFR 0.152.
 */
package com.verdegraphics.kidneycalc;

import com.verdegraphics.kidneycalc.CalculatorTUI;
import com.verdegraphics.kidneycalc.CockroftGaultCalculator;

public class CockroftGaultCalculatorTUI
extends CalculatorTUI {
    public CockroftGaultCalculatorTUI(CockroftGaultCalculator calculator) {
        this.calculator = calculator;
        this.displayCalculation();
    }

    @Override
    public final void displayCalculation() {
        CockroftGaultCalculator myCalculator = (CockroftGaultCalculator)this.calculator;
        System.out.println("      Equation: " + (Object)((Object)myCalculator.equation()));
        System.out.println("        Method: " + (Object)((Object)myCalculator.preferredMethod()));
        if (myCalculator.age() > 60.0 && myCalculator.serumCreatinine() < 1.0) {
            System.out.printf("CrCl(Scr=%.2f): %.1f mL/min%n", myCalculator.serumCreatinine(), myCalculator.calculateUsingPreferredMethod());
            System.out.printf("CrCl(Scr=%.2f): %.1f mL/min%n", (myCalculator.serumCreatinine() + 1.0) / 2.0, CockroftGaultCalculator.calculateUsingPerferredMethod(myCalculator.age(), (myCalculator.serumCreatinine() + 1.0) / 2.0, myCalculator.height(), myCalculator.weight(), myCalculator.sex(), myCalculator.stableRenalFunction()), myCalculator.calculateUsingPreferredMethod());
            System.out.printf("CrCl(Scr=1.00): %.1f mL/min%n", CockroftGaultCalculator.calculateUsingPerferredMethod(myCalculator.age(), 1.0, myCalculator.height(), myCalculator.weight(), myCalculator.sex(), myCalculator.stableRenalFunction()), myCalculator.calculateUsingPreferredMethod());
        } else {
            System.out.printf("          CrCl: %.1f mL/min%n", myCalculator.calculateUsingPreferredMethod());
        }
        if (myCalculator.disclaimers().size() > 0) {
            CockroftGaultCalculatorTUI.displayDisclaimers(myCalculator.disclaimers());
        }
    }
}

