/*
 * Decompiled with CFR 0.152.
 */
package com.verdegraphics.kidneycalc;

import com.verdegraphics.kidneycalc.Calculator;
import com.verdegraphics.kidneycalc.CalculatorParameter;
import com.verdegraphics.kidneycalc.Equation;
import com.verdegraphics.kidneycalc.Sex;
import com.verdegraphics.kidneycalc.WeightCalculator;
import java.util.ArrayList;

public class CockroftGaultCalculator
extends Calculator<Parameter> {
    private static final Equation EQUATION = Equation.COCKROFT_GAULT;
    private double age;
    private double serumCreatinine;
    private double height;
    private double weight;
    private Sex sex;
    private boolean stableRenalFunction;

    public CockroftGaultCalculator() {
        this.equation = EQUATION;
        this.disclaimers = new ArrayList();
    }

    public CockroftGaultCalculator(double age, double serumCreatinine, double height, double weight, Sex sex, boolean stableRenalFunction) {
        this();
        this.age = age;
        this.serumCreatinine = serumCreatinine;
        this.height = height;
        this.weight = weight;
        this.sex = sex;
        this.stableRenalFunction = stableRenalFunction;
    }

    @Override
    public void setValueForParameter(Object value, CalculatorParameter<Parameter> parameter) throws IllegalArgumentException {
        try {
            switch (parameter.getParameter()) {
                case AGE: {
                    this.setAge((Double)value);
                    break;
                }
                case SERUM_CREATININE: {
                    this.setSerumCreatinine((Double)value);
                    break;
                }
                case HEIGHT: {
                    this.setHeight((Double)value);
                    break;
                }
                case WEIGHT: {
                    this.setWeight((Double)value);
                    break;
                }
                case SEX: {
                    this.setSex((Sex)((Object)value));
                    break;
                }
                case STABLE_RENAL_FUNCTION: {
                    this.setStableRenalFunction((Boolean)value);
                }
            }
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private void setAge(double age) {
        this.age = age;
    }

    public double age() {
        return this.age;
    }

    private void setSerumCreatinine(double serumCreatinine) {
        this.serumCreatinine = serumCreatinine;
    }

    public double serumCreatinine() {
        return this.serumCreatinine;
    }

    private void setHeight(double height) {
        this.height = height;
    }

    public double height() {
        return this.height;
    }

    private void setWeight(double weight) {
        this.weight = weight;
    }

    public double weight() {
        return this.weight;
    }

    private void setSex(Sex sex) {
        this.sex = sex;
    }

    public Sex sex() {
        return this.sex;
    }

    public void setStableRenalFunction(boolean stableRenalFunction) {
        this.stableRenalFunction = stableRenalFunction;
    }

    public boolean stableRenalFunction() {
        return this.stableRenalFunction;
    }

    public double calculateUsingActualBodyWeight() {
        return (140.0 - this.age) * this.weight / (this.serumCreatinine * 72.0) * (this.sex == Sex.FEMALE ? 0.85 : 1.0);
    }

    public double calculateUsingIdealBodyWeight() {
        return (140.0 - this.age) * WeightCalculator.calculateIdealBodyWeight(this.age, this.height, this.sex) / (this.serumCreatinine * 72.0) * (this.sex == Sex.FEMALE ? 0.85 : 1.0);
    }

    public double calculateUsingAdjustedBodyWeight() {
        return (140.0 - this.age) * WeightCalculator.calculateAdjustedBodyWeight(this.age, this.height, this.weight, this.sex) / (this.serumCreatinine * 72.0) * (this.sex == Sex.FEMALE ? 0.85 : 1.0);
    }

    public Method preferredMethod() {
        this.disclaimers.clear();
        double BODY_MASS_INDEX_LOWER_CUTOFF = 18.5;
        double BODY_MASS_INDEX_UPPER_CUTOFF = 25.0;
        double bodyMassIndex = WeightCalculator.calculateBMI(this.height, this.weight);
        double idealBodyWeight = WeightCalculator.calculateIdealBodyWeight(this.age, this.height, this.sex);
        if (!this.stableRenalFunction) {
            this.disclaimers.add("Cockroft-Gault has not been validated in unstable renal function.");
        }
        if (this.age < 18.0) {
            this.disclaimers.add("Cockroft-Gault has not been validated in children 18 years or younger. Please consider the results of the Bedside Schwartz equation when assessing pediatric renal function.");
        }
        if (idealBodyWeight == 0.0 || this.weight < idealBodyWeight || bodyMassIndex < 18.5) {
            if (this.height == 0.0 && idealBodyWeight == 0.0) {
                this.disclaimers.add("Unable to assess body mass index without a height. Cockroft-Gault by actual body weight may not be accurate if the patient weights significantly more or less than ideal body weight.");
            }
            return Method.ACTUAL_BODY_WEIGHT;
        }
        if (this.weight > 1.3 * idealBodyWeight || bodyMassIndex > 25.0) {
            return Method.ADJUSTED_BODY_WEIGHT;
        }
        return Method.IDEAL_BODY_WEIGHT;
    }

    public double calculateUsingPreferredMethod() {
        switch (this.preferredMethod()) {
            case ACTUAL_BODY_WEIGHT: {
                return this.calculateUsingActualBodyWeight();
            }
            case ADJUSTED_BODY_WEIGHT: {
                return this.calculateUsingAdjustedBodyWeight();
            }
        }
        return this.calculateUsingIdealBodyWeight();
    }

    @Override
    public double calculate() {
        return this.calculateUsingPreferredMethod();
    }

    public static double calculateUsingPerferredMethod(double age, double serumCreatinine, double height, double weight, Sex sex, boolean stableRenalFunction) {
        CockroftGaultCalculator calculator = new CockroftGaultCalculator(age, serumCreatinine, height, weight, sex, stableRenalFunction);
        return calculator.calculateUsingPreferredMethod();
    }

    public static enum Method {
        ACTUAL_BODY_WEIGHT{

            public String toString() {
                return "Actual body weight";
            }
        }
        ,
        IDEAL_BODY_WEIGHT{

            public String toString() {
                return "Ideal body weight";
            }
        }
        ,
        ADJUSTED_BODY_WEIGHT{

            public String toString() {
                return "Adjusted body weight";
            }
        };

    }

    public static enum Parameter implements CalculatorParameter<Parameter>
    {
        AGE,
        SERUM_CREATININE,
        HEIGHT,
        WEIGHT,
        SEX,
        STABLE_RENAL_FUNCTION;


        @Override
        public Parameter getParameter() {
            return this;
        }
    }
}

