/*
 * Decompiled with CFR 0.152.
 */
package com.verdegraphics.kidneycalc;

import com.verdegraphics.kidneycalc.Calculator;
import com.verdegraphics.kidneycalc.CalculatorParameter;
import com.verdegraphics.kidneycalc.Equation;

public class BedsideSchwartzCalculator
extends Calculator<Parameter> {
    private static final Equation EQUATION = Equation.BEDSIDE_SCHWARTZ;
    private double age;
    private double serumCreatinine;
    private double height;
    private boolean stableRenalFunction;

    public BedsideSchwartzCalculator() {
        this.equation = EQUATION;
    }

    public BedsideSchwartzCalculator(double age, double serumCreatinine, double height, boolean stableRenalFunction) {
        this();
        this.age = age;
        this.serumCreatinine = serumCreatinine;
        this.height = height;
        this.stableRenalFunction = stableRenalFunction;
    }

    @Override
    public void setValueForParameter(Object value, CalculatorParameter<Parameter> parameter) throws IllegalArgumentException {
        try {
            switch (parameter.getParameter()) {
                case AGE: {
                    this.setAge((Double)value);
                }
                case SERUM_CREATININE: {
                    this.setSerumCreatinine((Double)value);
                    break;
                }
                case HEIGHT: {
                    this.setHeight((Double)value);
                    break;
                }
                case STABLE_RENAL_FUNCTION: {
                    this.setStableRenalFunction((Boolean)value);
                }
            }
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public double age() {
        return this.age;
    }

    public void setAge(double age) {
        this.age = age;
    }

    private void setSerumCreatinine(double serumCreatinine) {
        this.serumCreatinine = serumCreatinine;
    }

    public double serumCreatinine() {
        return this.serumCreatinine;
    }

    private void setHeight(double height) {
        this.height = height;
    }

    public double height() {
        return this.height;
    }

    public void setStableRenalFunction(boolean stableRenalFunction) {
        this.stableRenalFunction = stableRenalFunction;
    }

    public boolean stableRenalFunction() {
        return this.stableRenalFunction;
    }

    @Override
    public double calculate() {
        this.disclaimers.clear();
        if (this.age < 1.0) {
            this.disclaimers.add("Bedside-Schwartz has not been validated in children younger than 1 year.");
        }
        if (this.height == 0.0) {
            this.disclaimers.add("Bedside Schwartz requires a height. Please obtain a height to perform the calculation.");
        }
        if (!this.stableRenalFunction && !this.stableRenalFunction) {
            this.disclaimers.add("Bedside-Schwartz has not been validated in unstable renal function.");
        }
        return 0.413 * this.height() / this.serumCreatinine;
    }

    public static double calculate(double height, double serumCreatinine) {
        return 0.413 * height / serumCreatinine;
    }

    public static enum Parameter implements CalculatorParameter<Parameter>
    {
        AGE,
        SERUM_CREATININE,
        HEIGHT,
        STABLE_RENAL_FUNCTION;


        @Override
        public Parameter getParameter() {
            return this;
        }
    }
}

