/*
 * Decompiled with CFR 0.152.
 */
package com.verdegraphics.fmexcelerator;

import com.verdegraphics.fmexcelerator.ProgressListener;
import com.verdegraphics.fmexcelerator.ProgressUpdateEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFCreationHelper;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class XLSXFileWriter
implements Callable<Boolean> {
    private final File file;
    private final LinkedHashMap<String, List<Object[]>> data;
    private final int dataSize;
    private int amountDataWritten;
    private int progress;
    private String operationName;
    private final ArrayList<ProgressListener> progressListeners;

    public XLSXFileWriter(LinkedHashMap<String, List<Object[]>> data, File file) {
        this.file = file;
        this.data = data;
        int myDataSize = 0;
        for (List<Object[]> list : data.values()) {
            myDataSize += list.size();
        }
        this.dataSize = myDataSize;
        this.progressListeners = new ArrayList();
    }

    public void addProgressListener(ProgressListener listener) {
        this.progressListeners.add(listener);
    }

    public void removeProgressListener(ProgressListener listener) {
        this.progressListeners.remove(listener);
    }

    public void writeDataToFile() throws IOException, InterruptedException {
        this.operationName = ResourceBundle.getBundle("com/verdegraphics/fmexcelerator/Bundle").getString("writingXLSXFile...");
        this.setProgress(0);
        XSSFWorkbook xssfWorkbook = new XSSFWorkbook();
        XSSFCellStyle dateStyle = XLSXFileWriter.getDateStyle(xssfWorkbook);
        XSSFCellStyle dateTimeStyle = XLSXFileWriter.getDateTimeStyle(xssfWorkbook);
        SXSSFWorkbook workbook = new SXSSFWorkbook(xssfWorkbook, 100);
        for (String sheetName : this.data.keySet()) {
            this.operationName = ResourceBundle.getBundle("com/verdegraphics/fmexcelerator/Bundle").getString("writingXLSXFile...");
            SXSSFSheet sheet = workbook.createSheet(sheetName);
            int rowNumber = 0;
            for (Object[] dataRow : this.data.get(sheetName)) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                Row row = sheet.createRow(rowNumber++);
                int cellNumber = 0;
                for (Object dataObject : dataRow) {
                    Cell cell = row.createCell(cellNumber++);
                    if (dataObject instanceof Double) {
                        cell.setCellValue((Double)dataObject);
                        continue;
                    }
                    if (dataObject instanceof Integer) {
                        cell.setCellValue(((Integer)dataObject).intValue());
                        continue;
                    }
                    if (dataObject instanceof LocalDate) {
                        cell.setCellValue(Date.from(((LocalDate)dataObject).atStartOfDay(ZoneId.systemDefault()).toInstant()));
                        cell.setCellStyle(dateStyle);
                        continue;
                    }
                    if (dataObject instanceof LocalDateTime) {
                        cell.setCellValue(GregorianCalendar.from(((LocalDateTime)dataObject).atZone(ZoneId.systemDefault())));
                        cell.setCellStyle(dateTimeStyle);
                        continue;
                    }
                    if (dataObject instanceof String[]) {
                        int arrayLength = ((String[])dataObject).length;
                        StringBuilder stringBuilder = new StringBuilder();
                        if (arrayLength > 0) {
                            for (int i = 0; i < arrayLength; ++i) {
                                stringBuilder.append(((String[])dataObject)[i]);
                                if (i < arrayLength - 1) {
                                    stringBuilder.append("; ");
                                    continue;
                                }
                                stringBuilder.append(".");
                            }
                        }
                        cell.setCellValue(stringBuilder.toString());
                        continue;
                    }
                    if (dataObject == null) continue;
                    cell.setCellValue(dataObject.toString());
                }
                this.updateAmountDataWritten(1);
            }
        }
        FileOutputStream out = new FileOutputStream(this.file);
        workbook.write(out);
        out.close();
        workbook.dispose();
    }

    private static XSSFCellStyle getDateStyle(XSSFWorkbook workbook) {
        XSSFCreationHelper createHelper = workbook.getCreationHelper();
        XSSFCellStyle cellStyle = workbook.createCellStyle();
        cellStyle.setDataFormat(createHelper.createDataFormat().getFormat("yyyy-MM-dd"));
        return cellStyle;
    }

    private static XSSFCellStyle getDateTimeStyle(XSSFWorkbook workbook) {
        XSSFCreationHelper createHelper = workbook.getCreationHelper();
        XSSFCellStyle cellStyle = workbook.createCellStyle();
        cellStyle.setDataFormat(createHelper.createDataFormat().getFormat("yyyy-MM-dd HH:mm"));
        return cellStyle;
    }

    private synchronized void updateAmountDataWritten(int dataProcessed) {
        this.amountDataWritten += dataProcessed;
        this.setProgress(Math.min((int)(100.0 * (double)this.amountDataWritten / (double)this.dataSize), 99));
    }

    private synchronized void setAmountDataRead(int dataProcessed) {
        this.amountDataWritten = dataProcessed;
    }

    private synchronized void setProgress(int progress) {
        this.progress = progress;
        for (ProgressListener listener : this.progressListeners) {
            listener.progressUpdated(new ProgressUpdateEvent(this.getCurrentOperation(), this.getProgress(), this.getAmountDataWritten(), this.getTotalDataToWrite()));
        }
    }

    public synchronized int getProgress() {
        return this.progress;
    }

    public synchronized long getAmountDataWritten() {
        return this.amountDataWritten;
    }

    public long getTotalDataToWrite() {
        return this.dataSize;
    }

    public synchronized String getCurrentOperation() {
        return this.operationName;
    }

    public synchronized void setCurrentOperation(String operation) {
        this.operationName = operation;
        for (ProgressListener listener : this.progressListeners) {
            listener.progressUpdated(new ProgressUpdateEvent(this.getCurrentOperation(), this.getProgress(), this.getAmountDataWritten(), this.getTotalDataToWrite()));
        }
    }

    @Override
    public Boolean call() throws Exception {
        try {
            this.writeDataToFile();
        }
        catch (InterruptedException e) {
            this.file.delete();
            return false;
        }
        return true;
    }
}

