/*
 * Decompiled with CFR 0.152.
 */
package com.verdegraphics.fmexcelerator;

import com.verdegraphics.fmexcelerator.ProgressListener;
import com.verdegraphics.fmexcelerator.ProgressUpdateEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;

public class ReportProcessor
implements Callable<ArrayList<Object[]>> {
    private static final String DELIMITER = "^";
    private final File vgenReport;
    private final int delimPerLine;
    ArrayList<Object[]> data;
    private final long fileSize;
    private long amountDataRead;
    private int progress;
    private static final String OPERATION_NAME = ResourceBundle.getBundle("com/verdegraphics/fmexcelerator/Bundle").getString("processingFMReport...");
    private final ArrayList<ProgressListener> progressListeners;

    public ReportProcessor(File vgenReport, int delimPerLine) {
        this.vgenReport = vgenReport;
        this.delimPerLine = delimPerLine;
        this.data = new ArrayList();
        this.fileSize = vgenReport.length();
        this.progressListeners = new ArrayList();
    }

    public ReportProcessor(File vgenReport) throws IOException {
        this.vgenReport = vgenReport;
        this.delimPerLine = this.delimPerLine();
        this.data = new ArrayList();
        this.fileSize = vgenReport.length();
        this.progressListeners = new ArrayList();
    }

    public void addProgressListener(ProgressListener listener) {
        this.progressListeners.add(listener);
    }

    public void removeProgressListener(ProgressListener listener) {
        this.progressListeners.remove(listener);
    }

    public ArrayList<Object[]> processReport() throws IOException, InterruptedException {
        String inputLine;
        this.setProgress(0);
        BufferedReader reader = new BufferedReader(new FileReader(this.vgenReport));
        StringBuilder outputLine = new StringBuilder();
        boolean delimCount = false;
        boolean endOfRow = false;
        boolean firstLine = true;
        while ((inputLine = reader.readLine()) != null) {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            this.updateAmountDataRead(inputLine.length());
            try {
                if (inputLine.isEmpty() && (inputLine = reader.readLine()).isEmpty()) {
                }
            }
            catch (NullPointerException e) {}
            break;
            if (inputLine.isEmpty() || inputLine.contains("DEVICE") || (inputLine.contains("SEARCH") || inputLine.contains("LIST")) && inputLine.contains("PAGE") || inputLine.contains("-----------------------------------------")) continue;
            if ((inputLine = inputLine.replaceAll(String.format("%n", new Object[0]), "")).contains("\\\\")) {
                inputLine = inputLine.replaceAll(String.format("\\\\", new Object[0]), "");
                outputLine.append(inputLine.trim());
                this.data.add(ReportProcessor.processRow(outputLine.toString()));
                outputLine = new StringBuilder();
                continue;
            }
            outputLine.append(inputLine.trim());
        }
        reader.close();
        if (!outputLine.toString().isEmpty()) {
            this.data.add(ReportProcessor.processRow(outputLine.toString()));
        }
        this.setAmountDataRead(this.fileSize);
        this.setProgress(100);
        return this.data;
    }

    private int delimPerLine() throws IOException {
        String inputLine;
        BufferedReader reader = new BufferedReader(new FileReader(this.vgenReport));
        StringBuilder outputLine = new StringBuilder();
        int delimCount = 0;
        boolean endOfHeaders = false;
        while ((inputLine = reader.readLine()) != null && !endOfHeaders) {
            if (inputLine.isEmpty()) continue;
            if (Character.isDigit(inputLine.charAt(0))) {
                endOfHeaders = true;
                continue;
            }
            delimCount += inputLine.length() - inputLine.replace(DELIMITER, "").length();
        }
        return delimCount;
    }

    private static Object[] processRow(String row) {
        String[] lineComponents = row.split("\\^");
        Object[] rowData = new Object[lineComponents.length];
        for (int i = 0; i < lineComponents.length; ++i) {
            int j;
            String[] entries;
            StringBuilder entrySet;
            lineComponents[i] = lineComponents[i].trim();
            if (lineComponents[i].contains(";")) {
                entrySet = new StringBuilder();
                entries = lineComponents[i].split(";");
                for (j = 0; j < entries.length; ++j) {
                    entrySet.append(entries[j].trim());
                    if (j == entries.length - 1) continue;
                    entrySet.append("; ");
                }
                lineComponents[i] = entrySet.toString();
            }
            if (lineComponents[i].contains("=")) {
                entrySet = new StringBuilder();
                entries = lineComponents[i].split(";");
                for (j = 0; j < entries.length; ++j) {
                    String[] elements = entries[j].split("=");
                    for (int k = 0; k < elements.length; ++k) {
                        entrySet.append(elements[k].trim());
                        if (k % 2 == 0) {
                            entrySet.append("=");
                        }
                        if (k % 2 != 1 || j == entries.length - 1) continue;
                        entrySet.append("; ");
                    }
                }
                lineComponents[i] = entrySet.toString();
            }
            try {
                int value = Integer.parseInt(lineComponents[i]);
                rowData[i] = value;
                continue;
            }
            catch (NumberFormatException value) {
                try {
                    double value2 = Double.parseDouble(lineComponents[i]);
                    rowData[i] = value2;
                    continue;
                }
                catch (NumberFormatException value2) {
                    try {
                        LocalDate value3 = LocalDate.parse(lineComponents[i], DateTimeFormatter.ofPattern("MM/dd/yyyy"));
                        rowData[i] = value3;
                        continue;
                    }
                    catch (DateTimeParseException value3) {
                        try {
                            LocalDate value4 = LocalDate.parse(lineComponents[i], DateTimeFormatter.ofPattern("M/d/yyyy"));
                            rowData[i] = value4;
                            continue;
                        }
                        catch (DateTimeParseException value4) {
                            try {
                                LocalDate value5 = LocalDate.parse(lineComponents[i], DateTimeFormatter.ofPattern("MM/d/yyyy"));
                                rowData[i] = value5;
                                continue;
                            }
                            catch (DateTimeParseException value5) {
                                try {
                                    LocalDate value6 = LocalDate.parse(lineComponents[i], DateTimeFormatter.ofPattern("M/dd/yyyy"));
                                    rowData[i] = value6;
                                    continue;
                                }
                                catch (DateTimeParseException value6) {
                                    try {
                                        LocalDateTime value7 = LocalDateTime.parse(lineComponents[i], DateTimeFormatter.ofPattern("MM/dd/yyyy HH:mm:ss"));
                                        rowData[i] = value7;
                                        continue;
                                    }
                                    catch (DateTimeParseException value7) {
                                        try {
                                            LocalDateTime value8 = LocalDateTime.parse(lineComponents[i], DateTimeFormatter.ofPattern("M/dd/yyyy HH:mm:ss"));
                                            rowData[i] = value8;
                                            continue;
                                        }
                                        catch (DateTimeParseException value8) {
                                            try {
                                                LocalDateTime value9 = LocalDateTime.parse(lineComponents[i], DateTimeFormatter.ofPattern("MM/d/yyyy HH:mm:ss"));
                                                rowData[i] = value9;
                                                continue;
                                            }
                                            catch (DateTimeParseException value9) {
                                                try {
                                                    LocalDateTime value10 = LocalDateTime.parse(lineComponents[i], DateTimeFormatter.ofPattern("M/d/yyyy HH:mm:ss"));
                                                    rowData[i] = value10;
                                                    continue;
                                                }
                                                catch (DateTimeParseException value10) {
                                                    try {
                                                        LocalDateTime value11 = LocalDateTime.parse(lineComponents[i], DateTimeFormatter.ofPattern("MM/dd/yyyy HH:mm"));
                                                        rowData[i] = value11;
                                                        continue;
                                                    }
                                                    catch (DateTimeParseException value11) {
                                                        try {
                                                            LocalDateTime value12 = LocalDateTime.parse(lineComponents[i], DateTimeFormatter.ofPattern("M/dd/yyyy HH:mm"));
                                                            rowData[i] = value12;
                                                            continue;
                                                        }
                                                        catch (DateTimeParseException value12) {
                                                            try {
                                                                LocalDateTime value13 = LocalDateTime.parse(lineComponents[i], DateTimeFormatter.ofPattern("MM/d/yyyy HH:mm"));
                                                                rowData[i] = value13;
                                                                continue;
                                                            }
                                                            catch (DateTimeParseException value13) {
                                                                try {
                                                                    LocalDateTime value14 = LocalDateTime.parse(lineComponents[i], DateTimeFormatter.ofPattern("M/d/yyyy HH:mm"));
                                                                    rowData[i] = value14;
                                                                    continue;
                                                                }
                                                                catch (DateTimeParseException value14) {
                                                                    try {
                                                                        LocalDateTime value15 = LocalDateTime.parse(lineComponents[i], DateTimeFormatter.ofPattern("MM/dd/yyyy@HH:mm:ss"));
                                                                        rowData[i] = value15;
                                                                        continue;
                                                                    }
                                                                    catch (DateTimeParseException value15) {
                                                                        try {
                                                                            LocalDateTime value16 = LocalDateTime.parse(lineComponents[i], DateTimeFormatter.ofPattern("MM/d/yyyy@HH:mm:ss"));
                                                                            rowData[i] = value16;
                                                                            continue;
                                                                        }
                                                                        catch (DateTimeParseException value16) {
                                                                            try {
                                                                                LocalDateTime value17 = LocalDateTime.parse(lineComponents[i], DateTimeFormatter.ofPattern("M/dd/yyyy@HH:mm:ss"));
                                                                                rowData[i] = value17;
                                                                                continue;
                                                                            }
                                                                            catch (DateTimeParseException value17) {
                                                                                try {
                                                                                    LocalDateTime value18 = LocalDateTime.parse(lineComponents[i], DateTimeFormatter.ofPattern("M/d/yyyy@HH:mm:ss"));
                                                                                    rowData[i] = value18;
                                                                                    continue;
                                                                                }
                                                                                catch (DateTimeParseException value18) {
                                                                                    try {
                                                                                        LocalDateTime value19 = LocalDateTime.parse(lineComponents[i], DateTimeFormatter.ofPattern("MM/dd/yyyy@HH:mm"));
                                                                                        rowData[i] = value19;
                                                                                        continue;
                                                                                    }
                                                                                    catch (DateTimeParseException value19) {
                                                                                        try {
                                                                                            LocalDateTime value20 = LocalDateTime.parse(lineComponents[i], DateTimeFormatter.ofPattern("M/dd/yyyy@HH:mm"));
                                                                                            rowData[i] = value20;
                                                                                            continue;
                                                                                        }
                                                                                        catch (DateTimeParseException value20) {
                                                                                            try {
                                                                                                LocalDateTime value21 = LocalDateTime.parse(lineComponents[i], DateTimeFormatter.ofPattern("MM/d/yyyy@HH:mm"));
                                                                                                rowData[i] = value21;
                                                                                                continue;
                                                                                            }
                                                                                            catch (DateTimeParseException value21) {
                                                                                                try {
                                                                                                    LocalDateTime value22 = LocalDateTime.parse(lineComponents[i], DateTimeFormatter.ofPattern("M/d/yyyy@HH:mm"));
                                                                                                    rowData[i] = value22;
                                                                                                    continue;
                                                                                                }
                                                                                                catch (DateTimeParseException dateTimeParseException) {
                                                                                                    rowData[i] = lineComponents[i];
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return rowData;
    }

    private synchronized void updateAmountDataRead(long dataProcessed) {
        this.amountDataRead += dataProcessed;
        this.setProgress(Math.min((int)(100.0 * (double)this.amountDataRead / (double)this.fileSize), 99));
    }

    private synchronized void setAmountDataRead(long dataProcessed) {
        this.amountDataRead = dataProcessed;
        this.setProgress(Math.min((int)(100.0 * (double)this.amountDataRead / (double)this.fileSize), 99));
    }

    private synchronized void setProgress(int progress) {
        this.progress = progress;
        for (ProgressListener listener : this.progressListeners) {
            listener.progressUpdated(new ProgressUpdateEvent(OPERATION_NAME, this.getProgress(), this.getAmountDataRead(), this.getTotalDataToRead()));
        }
    }

    public synchronized int getProgress() {
        return this.progress;
    }

    public synchronized long getAmountDataRead() {
        return this.amountDataRead;
    }

    public long getTotalDataToRead() {
        return this.fileSize;
    }

    public String currentOperation() {
        return OPERATION_NAME;
    }

    @Override
    public ArrayList<Object[]> call() throws IOException, InterruptedException {
        return this.processReport();
    }
}

