/*
 * Decompiled with CFR 0.152.
 */
package com.verdegraphics.fmexcelerator;

import com.verdegraphics.fmexcelerator.ProgressListener;
import com.verdegraphics.fmexcelerator.ProgressUpdateEvent;
import com.verdegraphics.fmexcelerator.ReportProcessor;
import com.verdegraphics.fmexcelerator.XLSXFileFilter;
import com.verdegraphics.fmexcelerator.XLSXFileWriter;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class FMExceleratorTUI {
    private final ExecutorService executor;
    private boolean overwrite = false;
    private final File inFile;
    private final File outFile;
    private final int delimPerLine;

    public FMExceleratorTUI(String ... args) {
        String delimPerLineString;
        File myOutFile;
        if (args.length < 2 || args.length > 4) {
            System.err.println("Usage: ReportProcessor [-R] infile outfile [delimPerLine]");
            this.executor = null;
            this.inFile = null;
            this.outFile = null;
            this.delimPerLine = 0;
            return;
        }
        if (args[0].equals("-R")) {
            this.overwrite = true;
            this.inFile = new File(args[1]);
            myOutFile = new File(args[2]);
            delimPerLineString = args.length == 4 ? args[3] : "-1";
        } else {
            this.inFile = new File(args[0]);
            myOutFile = new File(args[1]);
            delimPerLineString = args.length == 3 ? args[2] : "-1";
        }
        String extension = XLSXFileFilter.getExtension(myOutFile);
        if (extension == null || !extension.equalsIgnoreCase("xlsx")) {
            myOutFile = new File(myOutFile.getAbsolutePath() + ".xlsx");
        }
        this.outFile = myOutFile;
        int myDelimPerLine = 0;
        try {
            myDelimPerLine = Integer.parseInt(delimPerLineString);
        }
        catch (NumberFormatException e) {
            System.err.println();
            System.err.println("The number of delimiters per line argument must be an integer.");
            this.executor = null;
            this.delimPerLine = 0;
            return;
        }
        this.delimPerLine = myDelimPerLine;
        this.executor = Executors.newSingleThreadExecutor();
        this.displayTUI();
    }

    private void displayTUI() {
        System.out.printf("___    _______________________   __%n__ |  / /_  ____/__  ____/__  | / /%n__ | / /_  / __ __  __/  __   |/ /%n__ |/ / / /_/ / _  /___  _  /|  /%n_____/  \\____/  /_____/  /_/ |_/%n__________                 ______                  _____%n___  ____/___  _______________  /_________________ __  /______________%n__  __/  __  |/_/  ___/  _ \\_  /_  _ \\_  ___/  __ `/  __/  __ \\_  ___/%n_  /___  __>  < / /__ /  __/  / /  __/  /   / /_/ // /_ / /_/ /  /%n/_____/  /_/|_| \\___/ \\___//_/  \\___//_/    \\__,_/ \\__/ \\____//_/%n%n", new Object[0]);
        System.out.printf("Version %s%n%n", "0.1 alpha");
        System.out.printf("A utility to easily convert RPMS FM reports into Excel,%nwith absolutely no limit on the number of characters per line,%nand without needing to maximize the SecureCRT window.%n%n", new Object[0]);
        System.out.println("Copyright (c) 2019 LT Nicholas Stauffer, PharmD");
        System.out.println();
        try {
            if (this.outFile.exists() && !this.overwrite) {
                System.out.printf("The specified output file already exists.%nTo overwrite it, run the program again with the -R flag:%nFMExcelerator -R infile outfile delimPerLine%n", new Object[0]);
                return;
            }
            ReportProcessor processor = this.delimPerLine == -1 ? new ReportProcessor(this.inFile) : new ReportProcessor(this.inFile, this.delimPerLine);
            processor.addProgressListener(new TextProgressListener());
            LinkedHashMap<String, List<Object[]>> data = new LinkedHashMap<String, List<Object[]>>();
            data.put(ResourceBundle.getBundle("com/verdegraphics/fmexcelerator/Bundle").getString("vgenExcelerator"), (List)this.executor.submit(processor).get());
            Thread.sleep(1000L);
            if (this.outFile.exists() && this.overwrite) {
                System.out.print("\r");
                System.out.print("                                                                           ");
                System.out.print("\r");
                System.out.print("The specified output file already exists, overwriting...");
                System.out.print("\r");
                Thread.sleep(3000L);
            }
            XLSXFileWriter writer = new XLSXFileWriter(data, this.outFile);
            writer.addProgressListener(new TextProgressListener());
            this.executor.submit(writer).get();
            System.out.print(" ");
            Thread.sleep(1000L);
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            System.err.println();
            System.err.println("An error occurred while reading/writing.");
            e.printStackTrace();
            return;
        }
        System.out.print("\r");
        System.out.print("                                                                           ");
        System.out.print("\r");
        System.out.println(" ***************************************************************");
        System.out.println(" *                                                             *");
        System.out.println(" *                            WARNING                          *");
        System.out.println(" *               CONFIDENTIAL PATIENT INFORMATION              *");
        System.out.println(" *                                                             *");
        System.out.println(" ***************************************************************");
        System.out.println(" *                                                             *");
        System.out.println(" * The file generated by this program may contain confidential *");
        System.out.println(" *     patient information. This file should be stored in      *");
        System.out.println(" *               accordance with federal policy.               *");
        System.out.println(" *                                                             *");
        System.out.println(" ***************************************************************");
        System.out.println("Data written successfully.");
    }

    private class TextProgressListener
    implements ProgressListener {
        long displayLastUpdated = 0L;
        static final long DISPLAY_UPDATE_DELAY = 100L;
        String lastOperation = "";

        private TextProgressListener() {
        }

        private void updateDisplay(ProgressUpdateEvent event) {
            this.displayLastUpdated = System.currentTimeMillis();
            this.lastOperation = event.getOperationName();
            System.out.print("\r");
            System.out.print("                                                                           ");
            System.out.print("\r");
            String progressBar = "";
            for (int i = 0; i < event.getProgress() / 5; ++i) {
                progressBar = progressBar + "/";
            }
            System.out.printf("%25s: %3d%% [%s] (%d/%d)", event.getOperationName(), event.getProgress(), String.format("%1$-20s", progressBar), event.getAmountDone(), event.getTotalAmountToDo());
        }

        @Override
        public void progressUpdated(ProgressUpdateEvent event) {
            if (event.getAmountDone() == 0L || !this.lastOperation.equals(event.getOperationName()) || event.getProgress() == 100 || System.currentTimeMillis() > this.displayLastUpdated + 100L) {
                this.updateDisplay(event);
            }
        }
    }
}

