/*
 * Decompiled with CFR 0.152.
 */
package com.verdegraphics.fmexcelerator;

import com.verdegraphics.fmexcelerator.AboutDialog;
import com.verdegraphics.fmexcelerator.CancelEvent;
import com.verdegraphics.fmexcelerator.CancelListener;
import com.verdegraphics.fmexcelerator.FMFileChooser;
import com.verdegraphics.fmexcelerator.InstructionsDialog;
import com.verdegraphics.fmexcelerator.ProgressIndicatorDialog;
import com.verdegraphics.fmexcelerator.ReportProcessor;
import com.verdegraphics.fmexcelerator.XLSXFileChooser;
import com.verdegraphics.fmexcelerator.XLSXFileFilter;
import com.verdegraphics.fmexcelerator.XLSXFileWriter;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;

public class FMExceleratorGUI
extends JFrame
implements CancelListener {
    private static File vgenReport;
    private static ExecutorService executor;
    private static SwingWorker<Void, Void> worker;
    private JButton aboutButton;
    private JLabel developerBylineLabel;
    private JButton instructionsButton;
    private JButton loadReportButton;
    private JLabel reportProcessorTitleLabel;
    private JButton saveXLSXButton;
    private JPanel titlePanel;

    public FMExceleratorGUI() {
        this.initComponents();
    }

    private void displayErrorMessage(String title, String message) {
        JOptionPane.showMessageDialog(null, message, title, 0);
    }

    private void loadFMReportFile() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        FMFileChooser fileChooser = new FMFileChooser();
        int returnVal = fileChooser.showOpenDialog(this);
        if (returnVal == 0) {
            vgenReport = fileChooser.getSelectedFile();
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.saveXLSXButton.setEnabled(true);
    }

    private void processAndSaveReport() {
        final ProgressIndicatorDialog progressIndicator = new ProgressIndicatorDialog(this, true);
        progressIndicator.addCancelListener(this);
        executor = Executors.newSingleThreadExecutor();
        worker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() {
                String extension;
                LinkedHashMap<String, List<Object[]>> data = new LinkedHashMap<String, List<Object[]>>();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        progressIndicator.setVisible(true);
                    }
                });
                try {
                    ReportProcessor processor = new ReportProcessor(vgenReport);
                    processor.addProgressListener(progressIndicator);
                    FMExceleratorGUI.this.setCursor(Cursor.getPredefinedCursor(3));
                    data.put(ResourceBundle.getBundle("com/verdegraphics/fmexcelerator/Bundle").getString("vgenExcelerator"), (List)executor.submit(processor).get());
                    FMExceleratorGUI.this.setCursor(Cursor.getPredefinedCursor(0));
                }
                catch (IOException | InterruptedException | ExecutionException ex) {
                    if (ex.getCause() instanceof InterruptedException) {
                        this.cancel(true);
                    }
                    FMExceleratorGUI.this.displayErrorMessage(ResourceBundle.getBundle("com/verdegraphics/fmexcelerator/Bundle").getString("error"), ResourceBundle.getBundle("com/verdegraphics/fmexcelerator/Bundle").getString("errorReadingFMReport"));
                    this.cancel(true);
                }
                progressIndicator.setVisible(false);
                if (this.isCancelled()) {
                    return null;
                }
                XLSXFileChooser xlsxFileChooser = new XLSXFileChooser();
                File xlsxFile = null;
                String defaultFileName = "FM Report " + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss")) + ".xlsx";
                xlsxFileChooser.setSelectedFile(new File(defaultFileName));
                JOptionPane.showMessageDialog(null, ResourceBundle.getBundle("com/verdegraphics/fmexcelerator/Bundle").getString("saveFileConfidentialityWarning"), ResourceBundle.getBundle("com/verdegraphics/fmexcelerator/Bundle").getString("warning"), 2);
                int returnVal = xlsxFileChooser.showSaveDialog(FMExceleratorGUI.this);
                if (!(returnVal != 0 || (extension = XLSXFileFilter.getExtension(xlsxFile = xlsxFileChooser.getSelectedFile())) != null && extension.equalsIgnoreCase("xlsx"))) {
                    xlsxFile = new File(xlsxFile.getAbsolutePath() + ".xlsx");
                }
                if (xlsxFile == null) {
                    return null;
                }
                XLSXFileWriter writer = new XLSXFileWriter(data, xlsxFile);
                writer.addProgressListener(progressIndicator);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        progressIndicator.setVisible(true);
                    }
                });
                FMExceleratorGUI.this.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    executor.submit(writer).get();
                }
                catch (InterruptedException ex) {
                    this.cancel(true);
                }
                catch (ExecutionException ex) {
                    FMExceleratorGUI.this.displayErrorMessage(ResourceBundle.getBundle("com/verdegraphics/fmexcelerator/Bundle").getString("error"), ResourceBundle.getBundle("com/verdegraphics/fmexcelerator/Bundle").getString("errorWritingFile") + String.format("%n", new Object[0]) + ex.getMessage());
                    this.cancel(true);
                }
                FMExceleratorGUI.this.setCursor(Cursor.getPredefinedCursor(0));
                if (this.isCancelled()) {
                    return null;
                }
                JOptionPane.showMessageDialog(null, ResourceBundle.getBundle("com/verdegraphics/fmexcelerator/Bundle").getString("xlsxFileWrittenSuccessfully"), ResourceBundle.getBundle("com/verdegraphics/fmexcelerator/Bundle").getString("xlsxFileWrittenSuccessfullyTitle"), 1);
                System.exit(0);
                return null;
            }
        };
        this.setCursor(Cursor.getPredefinedCursor(3));
        worker.execute();
    }

    @Override
    public void cancelled(CancelEvent event) {
        executor.shutdownNow();
        this.setCursor(Cursor.getPredefinedCursor(0));
        worker.cancel(true);
    }

    private void initComponents() {
        this.titlePanel = new JPanel();
        this.reportProcessorTitleLabel = new JLabel();
        this.developerBylineLabel = new JLabel();
        this.aboutButton = new JButton();
        this.loadReportButton = new JButton();
        this.instructionsButton = new JButton();
        this.saveXLSXButton = new JButton();
        this.setDefaultCloseOperation(3);
        ResourceBundle bundle = ResourceBundle.getBundle("com/verdegraphics/fmexcelerator/Bundle");
        this.setTitle(bundle.getString("vgenExcelerator"));
        this.setMinimumSize(new Dimension(350, 150));
        this.setResizable(false);
        this.reportProcessorTitleLabel.setFont(this.reportProcessorTitleLabel.getFont().deriveFont(this.reportProcessorTitleLabel.getFont().getStyle() | 1, this.reportProcessorTitleLabel.getFont().getSize() + 5));
        this.reportProcessorTitleLabel.setText(bundle.getString("vgenExcelerator"));
        this.developerBylineLabel.setFont(this.developerBylineLabel.getFont().deriveFont(this.developerBylineLabel.getFont().getStyle() | 2));
        this.developerBylineLabel.setText(bundle.getString("developedByline"));
        GroupLayout titlePanelLayout = new GroupLayout(this.titlePanel);
        this.titlePanel.setLayout(titlePanelLayout);
        titlePanelLayout.setHorizontalGroup(titlePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(titlePanelLayout.createSequentialGroup().addComponent(this.reportProcessorTitleLabel).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.developerBylineLabel, -1, -1, Short.MAX_VALUE));
        titlePanelLayout.setVerticalGroup(titlePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(titlePanelLayout.createSequentialGroup().addComponent(this.reportProcessorTitleLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.developerBylineLabel)));
        this.reportProcessorTitleLabel.getAccessibleContext().setAccessibleName("");
        this.reportProcessorTitleLabel.getAccessibleContext().setAccessibleDescription("");
        this.aboutButton.setText(bundle.getString("about"));
        this.aboutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FMExceleratorGUI.this.aboutButtonActionPerformed(evt);
            }
        });
        this.loadReportButton.setText(bundle.getString("loadFMReport..."));
        this.loadReportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FMExceleratorGUI.this.loadReportButtonActionPerformed(evt);
            }
        });
        this.instructionsButton.setText(bundle.getString("viewInstructions"));
        this.instructionsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FMExceleratorGUI.this.instructionsButtonActionPerformed(evt);
            }
        });
        this.saveXLSXButton.setText(bundle.getString("saveXLSX..."));
        this.saveXLSXButton.setEnabled(false);
        this.saveXLSXButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FMExceleratorGUI.this.saveXLSXButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.instructionsButton, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.titlePanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.aboutButton)).addComponent(this.loadReportButton, -1, -1, Short.MAX_VALUE).addComponent(this.saveXLSXButton, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.titlePanel, -2, -1, -2).addComponent(this.aboutButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.instructionsButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.loadReportButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.saveXLSXButton).addContainerGap()));
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private void aboutButtonActionPerformed(ActionEvent evt) {
        AboutDialog dialog = new AboutDialog((Frame)this, true);
        dialog.setVisible(true);
    }

    private void instructionsButtonActionPerformed(ActionEvent evt) {
        InstructionsDialog dialog = new InstructionsDialog((Frame)this, true);
        dialog.setVisible(true);
    }

    private void loadReportButtonActionPerformed(ActionEvent evt) {
        this.loadFMReportFile();
    }

    private void saveXLSXButtonActionPerformed(ActionEvent evt) {
        this.processAndSaveReport();
    }
}

