/*
 * Decompiled with CFR 0.152.
 */
package com.verdegraphics.datewheel;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.regex.Pattern;

public class LocalDateParser {
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("[M-d-yyyy HH:mm][yyyy-M-d HH:mm][yyyy-M-d][M-d-yyyy]");
    private static final Pattern NOT_DIGITS = Pattern.compile("[^\\d]");

    public static LocalDate parseDate(String date) throws DateTimeParseException {
        if (date.toUpperCase().contains("T")) {
            if (date.length() == 1) {
                return LocalDate.now();
            }
            try {
                int quantityToAdd;
                switch (date.trim().charAt(1)) {
                    case '+': {
                        quantityToAdd = Integer.parseInt(NOT_DIGITS.matcher(date).replaceAll(""));
                        break;
                    }
                    case '-': {
                        quantityToAdd = -Integer.parseInt(NOT_DIGITS.matcher(date).replaceAll(""));
                        break;
                    }
                    default: {
                        throw new DateTimeParseException("Invalid date format", date.trim(), 1);
                    }
                }
                if (date.toUpperCase().contains("Y")) {
                    return LocalDate.now().plusYears(quantityToAdd);
                }
                if (date.toUpperCase().contains("M")) {
                    return LocalDate.now().plusMonths(quantityToAdd);
                }
                if (date.toUpperCase().contains("D") || date.trim().toUpperCase().endsWith(String.format("%d", quantityToAdd))) {
                    return LocalDate.now().plusDays(quantityToAdd);
                }
                throw new DateTimeParseException("Invalid date format", date.trim(), date.trim().indexOf(String.format("%d", quantityToAdd) + String.format("%d", quantityToAdd).length()));
            }
            catch (NumberFormatException e) {
                throw new DateTimeParseException("Invalid date format", date.trim(), 1);
            }
        }
        date = date.trim();
        date = date.replace(".", "-");
        date = date.replace("/", "-");
        return LocalDate.parse(date, DATE_FORMATTER);
    }
}

