/*
 * Decompiled with CFR 0.152.
 */
package com.verdegraphics.datewheel;

import com.verdegraphics.analyticsreporter.AnalyticsReporter;
import com.verdegraphics.datewheel.LocalDateParser;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Scanner;

public class DateWheel {
    private Scanner scanner;
    private static final String APPLICATION_NAME = "DateWheel";
    private static final String VERSION = "2.0";

    public DateWheel() {
        this.dateWheelTUI();
    }

    private void dateWheelTUI() {
        this.scanner = new Scanner(System.in);
        String month = new String();
        char[] monthChars = LocalDate.now().format(DateTimeFormatter.ofPattern("MMM")).toCharArray();
        for (int i = 0; i < monthChars.length; ++i) {
            month = month.concat("" + monthChars[i]);
            if (i >= monthChars.length - 1) continue;
            month = month.concat(" ");
        }
        month = month.toUpperCase();
        String day = new String();
        char[] dayChars = LocalDate.now().format(DateTimeFormatter.ofPattern("d")).toCharArray();
        day = dayChars.length == 2 ? day.concat("" + dayChars[0] + " " + dayChars[1]) : day.concat(" " + dayChars[0] + " ");
        System.out.printf("+-O-----O-+     ____        __     _       ____              __%n|  %s  |    / __ \\____ _/ /____| |     / / /_  ___  ___  / /%n|---------|   / / / / __ `/ __/ _ \\ | /| / / __ \\/ _ \\/ _ \\/ / %n|   %s   |  / /_/ / /_/ / /_/  __/ |/ |/ / / / /  __/  __/ /  %n+---------+ /_____/\\__,_/\\__/\\___/|__/|__/_/ /_/\\___/\\___/_/%n", month, day);
        String byline = "By LT Nick Stauffer";
        String version = "Version 2.0";
        System.out.print(byline);
        for (int i = 0; i < 63 - byline.length() - version.length(); ++i) {
            System.out.print(" ");
        }
        System.out.println(version);
        System.out.println("---------------------------------------------------------------");
        while (true) {
            String line;
            boolean validInput = false;
            LocalDate startingDate = LocalDate.now();
            int daysToAdd = 0;
            double daysToAddMultiplier = 1.0;
            do {
                System.out.print("Starting date: ");
                line = this.scanner.nextLine();
                try {
                    startingDate = LocalDateParser.parseDate(line);
                    validInput = true;
                }
                catch (DateTimeParseException e) {
                    System.out.println("Please include month, day, andfour-digit year.");
                    validInput = false;
                }
            } while (!validInput);
            do {
                System.out.print("Days to add [x multiplier]: ");
                line = this.scanner.nextLine();
                String[] lineParts = new String[]{line};
                if (line.contains("x")) {
                    lineParts = line.split("x");
                } else if (line.contains("X")) {
                    lineParts = line.split("X");
                } else if (line.contains("*")) {
                    lineParts = line.split("\\*");
                } else if (line.contains(",")) {
                    lineParts = line.split(",");
                }
                try {
                    daysToAdd = Integer.parseInt(lineParts[0]);
                    if (lineParts.length == 2) {
                        daysToAddMultiplier = Double.parseDouble(lineParts[1]);
                    }
                    validInput = true;
                }
                catch (NumberFormatException e) {
                    System.out.println("The number of days to add must be an integer.");
                    System.out.println("To use a multiplier, use the following example as a guide:");
                    System.out.println("To calculate 80% of 30 days, enter 30x0.8");
                    System.out.println("(You can also use X * or , instead of x and you can leave off the leading zero.)");
                    validInput = false;
                }
            } while (!validInput);
            new Thread(new AnalyticsReporter(APPLICATION_NAME, VERSION, "calculation performed")).start();
            System.out.println("---------------------------------------------------------------");
            System.out.print("Result: ");
            System.out.println(this.performDateCalculation(startingDate, daysToAdd, daysToAddMultiplier).format(DateTimeFormatter.ISO_DATE));
            System.out.println("---------------------------------------------------------------");
            System.out.println();
        }
    }

    private LocalDate performDateCalculation(LocalDate date, int daysToAdd, double daysToAddMultiplier) {
        int actualDaysToAdd = (int)Math.ceil((double)daysToAdd * daysToAddMultiplier);
        return date.plusDays(actualDaysToAdd);
    }

    public static void main(String[] args) {
        new DateWheel();
    }
}

